package io.github.ibony.ats.common.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * Created by bony on 2017-06-24.
 */
public class Command {
    private static final Log logger = LogFactory.getLog(Command.class);
    boolean DEBUG = false;
    private Process process;
    private CommandListener commandListener = null;
    public BufferedWriter outputStream;
    BufferedReader inputStream;
    BufferedReader errorReader;
    boolean COLLECTOR_STATE = true;
    Thread dataCollector;
    private Queue<String> Results = new LinkedBlockingQueue<String>();
    String content = "";

    public Command() {
    }

    public Command(String content) throws Exception {
        COLLECTOR_STATE = true;
        this.content = content;
        process = Runtime.getRuntime().exec(content);
        start();
    }

    public Command(String[] content) throws Exception {
        COLLECTOR_STATE = true;
        for (String s : content) this.content += s;
        process = Runtime.getRuntime().exec(content);
        start();
    }

    public Command(String content, boolean debug) throws Exception {
        this.DEBUG = debug;
        COLLECTOR_STATE = true;
        this.content = content;
        process = Runtime.getRuntime().exec(content);
        start();
    }

    public Command(String[] content, boolean debug) throws Exception {
        this.DEBUG = debug;
        COLLECTOR_STATE = true;
        for (String s : content) this.content += s;
        process = Runtime.getRuntime().exec(content);
        start();
    }

    public boolean isClose() {
        return COLLECTOR_STATE;
    }

    //初始化取服务
    void start() throws Exception {
        if (DEBUG) logger.debug("start-> " + content);
        outputStream = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        inputStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
        errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        dataCollector = new Thread(new DataCollector());
        dataCollector.start();
    }

    /**
     * 读取完成之后关闭
     *
     * @return
     */
    public String readClose() {
        while (COLLECTOR_STATE) {
            try {
                Thread.sleep(0);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String a = "";
        for (String s : readLinesClose()) {
            a = a + s+"\n\n";
        }
//        String a = read();
//        close();
        return a;
    }

    /**
     * 读取完成之后关闭
     *
     * @return
     */
    public List<String> readLinesClose() {
        while (COLLECTOR_STATE) {
            try {
                Thread.sleep(0);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        List<String> res = readLines();
        close();
        return res;
    }

//    /**
//     * 读取完成之后关闭
//     *
//     * @return
//     */
//    public List<String> closeReadLines() {
//        close();
////        List<String> res = readLines();
//        return readLines();
//    }

    /**
     * 关闭流
     */
    public void close() {
        COLLECTOR_STATE = false;
        try {
            process.destroy();
            inputStream.close();
            outputStream.close();
            errorReader.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (DEBUG) logger.info("close-> " + content);
    }

    /**
     * 发送命令并读取返回
     *
     * @param content
     * @return
     */
//    public String scendRead(String content) {
//        try {
//            COLLECTOR_STATE = true;
//            outputStream.write(content + "\r\n");
//            outputStream.flush();
//            dataCollector = new Thread(new DataCollector());
//            dataCollector.start();
//            return read();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return null;
//    }

    /**
     * 发送命令并读取返回
     *
     * @param cmd
     * @return
     */
    public String put(String cmd) {
        try {
            COLLECTOR_STATE = true;
            outputStream.write(cmd + "\r\n");
            outputStream.flush();
            return read();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 读取返回
     *
     * @return
     */
    public String read() {
        String re = "";
        while (!Results.isEmpty()) {
            re += Results.poll() + "\r\n";
        }
        return re;
    }

    /**
     * 读取返回
     *
     * @return
     */
    public List<String> readLines() {
        List<String> res = new ArrayList<String>();
        while (!Results.isEmpty()) {
            res.add(Results.poll());
        }
        return res;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    /**
     * 数据收集器
     */
    class DataCollector implements Runnable {
        public void run() {
            inputStream.markSupported();
            String line;
            try {
                while (process.isAlive()){
                    while ((line = inputStream.readLine()) != null) {
                        if (line.length() > 0) {
                            if (commandListener != null) commandListener.handler(line);
                            else Results.add(line);
                        }
                    }
                    while ((line = errorReader.readLine()) != null) {
                        if (line.length() > 0) {
                            if (commandListener != null) commandListener.handler(line);
                            else Results.add(line);
                        }
                    }
                }
                COLLECTOR_STATE = false;
            } catch (IOException e) {
//                e.printStackTrace();
            }
        }
    }


}


