package io.github.ibony.ats.common.http;

import javax.net.ssl.*;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

/**
 * Created by bony on 2017-06-26.
 */
public class HttpConnection {
    private boolean IS_PROXY = false;//是否代理
    private String PROXY_HOST = null;//代理地址
    private int PROXY_PROT = 80;//是否端口

    /**
     * 设置代理
     * @param host 代理地址
     * @param prot 代理端口
     */
    public void setProxy(String host,int prot){
        this.IS_PROXY = true;
        this.PROXY_HOST = host;
        this.PROXY_PROT = prot;
    }
    /**
     * 去除代理
     */
    public void removProxy(){
        this.IS_PROXY = false;
    }

    public SSLSocketFactory getSSFactory() throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
            public boolean verify(String hostname, SSLSession sslsession) {
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[1];
        TrustManager tm = new BZX509TrustManager();
        trustAllCerts[0] = tm;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, null);
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        return  ssf;
    }
    public HttpsURLConnection getHttpsConnection(String url) throws Exception{
        URL _url = new URL(url);
        SSLSocketFactory ssf= getSSFactory();
        HttpsURLConnection Connection;
        if (IS_PROXY == true) {
        	System.out.println("我在这里设置代理！");
            Connection = (HttpsURLConnection) _url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY_HOST, PROXY_PROT)));// 打开和URL之间的连接
        } else {
            Connection = (HttpsURLConnection)_url.openConnection();// 打开和URL之间的连接
        }
        Connection.setSSLSocketFactory(ssf);
        return Connection;
    }
    public HttpURLConnection getHttpConnection(String url) throws Exception{
        URL _url = new URL(url);
        HttpURLConnection Connection;
        if (IS_PROXY == true) {
            Connection = (HttpURLConnection)_url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY_HOST, PROXY_PROT)));// 打开和URL之间的连接
        } else {
            Connection = (HttpURLConnection)_url.openConnection();// 打开和URL之间的连接
        }
        return Connection;
    }

}
