package io.github.ibony.ats.common.http;

import org.json.JSONException;
import org.json.JSONObject;

import javax.net.ssl.HttpsURLConnection;
import java.io.*;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by bony on 2017-06-26.
 */

public class Requests {
    public boolean IS_PROXY = false;//是否代理
    public String PROXY_HOST = null;//代理地址
    public int PROXY_PROT = 0;//是否端口
    public Map<String, String> HRADERS;//请求头
    public JSONObject PARAME;
    public JSONObject BODY;
    public String URL;//请求URL

    /**
     * 简化封装的get方法
     *
     * @param url      链接/地址
     * @param header   请求头
     * @param parame   JSONObject参数对象
     * @param protocol 请求协议类型 HTTP/HTTPS
     * @return InputStream对象
     */
    private Response get(String url, Map<String, String> header, JSONObject parame, String protocol) {
        return Send("get", url, getUrlArgs(parame), null, protocol);
    }

    /**
     * 简化封装的post方法
     *
     * @param url      链接/地址
     * @param header   请求头
     * @param parame   JSONObject参数对象
     * @param protocol 请求协议类型 HTTP/HTTPS
     * @return Response对象
     */
    private Response post(String url, Map<String, String> header, JSONObject parame, JSONObject body, String protocol) {
        return Send("post", url, getUrlArgs(parame), getUrlArgs(body), protocol);
    }

    /**
     * 简化封装的HttpsGet方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @return Response对象
     */
    public Response HttpsGet(String url, Map<String, String> header, JSONObject parame) {
        this.HRADERS = header;
        this.PARAME = parame;
        this.BODY = null;
        return get(url, header, parame, "https");
    }

    /**
     * 简化封装的HttpGet方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @return Response对象
     */
    public Response HttpGet(String url, Map<String, String> header, JSONObject parame) {
        this.HRADERS = header;
        this.PARAME = parame;
        this.BODY = null;
        return get(url, header, parame, "http");
    }

    /**
     * 简化封装的HttpsPost方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @param body   JSONObject参数对象
     * @return Response对象
     */
    public Response HttpsPost(String url, Map<String, String> header, JSONObject parame, JSONObject body) {
        this.HRADERS = header;
        this.PARAME = parame;
        this.BODY = body;
        return post(url, header, parame, body, "https");
    }

    /**
     * 简化封装的HttpPost方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @param body   参数
     * @return Response Response对象
     */
    public Response HttpPost(String url, Map<String, String> header, JSONObject parame, JSONObject body) {
        this.HRADERS = header;
        this.PARAME = parame;
        this.BODY = body;
        return post(url, header, parame, body, "http");
    }

    /**
     * 参数
     *
     * @param parame 参数对象
     * @return 结果
     */
    public String getUrlArgs(JSONObject parame) {
        String parame_tmp = "";
        if (parame != null && !parame.equals("")) {
            for (Iterator it = parame.keys(); it.hasNext(); ) {
                String key = (String) it.next();
                try {
                    if (parame.get(key) instanceof String) {
                        parame_tmp += key + "=" + parame.get(key) + "&";
                    } else {
                        // your code
                        parame_tmp += key + "=" + parame.get(key) + "&";
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return parame_tmp;
    }

    /**
     * 请求方法
     *
     * @param Type     请求属性 GET/POST
     * @param url      请求地址
     * @param param    请求参数
     * @param protocol 请求协议类型 HTTP/HTTPS
     * @return Response对象
     */
    private Response Send(String Type, String url, String param, String body, String protocol) {
        Response responses = new Response();
        try {
            if (param != null && !param.equals("")) {
                URL = url + "?" + param;
            } else URL = url;
            if (protocol.equals("http")) {
                HttpConnection httpConnection = new HttpConnection();
                if (IS_PROXY == true) httpConnection.setProxy(PROXY_HOST, PROXY_PROT);
                HttpURLConnection Connection = httpConnection.getHttpConnection(URL);
                Connection.setConnectTimeout(3000);//设置链连接超时
                Connection.setReadTimeout(3000);//设置读超时
                Iterator<Map.Entry<String, String>> entries = this.HRADERS.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, String> entry = entries.next();
                    Connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                if (Type.equals("post")) {
                    Connection.setDoOutput(true);//设置输出
                    Connection.setDoInput(true);//设置输入
                }
                Connection.connect();//建立连接
                if (Type.equals("post")) {
                    OutputStream output_stream = Connection.getOutputStream();//得到输出流
                    PrintWriter print_writer = new PrintWriter(output_stream);//创建输出流对象
                    print_writer.print(body);
                    print_writer.flush();// flush输出流的缓冲
                }
                responses.CODE = Connection.getResponseCode();//得到响应代码
                responses.MESSAGE = Connection.getResponseMessage();//回应信息
                responses.InputStream = Connection.getInputStream();//创建输入流对象
                ByteArrayOutputStream bytearrayoutputstream = Read(responses.InputStream);
                responses.HEADERS = Connection.getHeaderFields();
                responses.URL = Connection.getURL().toString();
                responses.CONTENT = bytearrayoutputstream.toByteArray();
                responses.TEXT = bytearrayoutputstream.toString();
            } else if (protocol.equals("https")) {
                HttpsURLConnection Connection = new HttpConnection().getHttpsConnection(URL);
                Connection.setConnectTimeout(1500);//设置链连接超时
                Connection.setReadTimeout(1500);//设置读超时
                Iterator<Map.Entry<String, String>> entries = this.HRADERS.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, String> entry = entries.next();
                    Connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                if (Type.equals("post")) {
                    Connection.setDoOutput(true);//设置输出
                    Connection.setDoInput(true);//设置输入
                }
                Connection.connect();//建立连接
                if (Type.equals("post")) {
                    OutputStream output_stream = Connection.getOutputStream();//得到输出流
                    PrintWriter print_writer = new PrintWriter(output_stream);//创建输出流对象
                    print_writer.print(body);
                    print_writer.flush();// flush输出流的缓冲
                }
                responses.CODE = Connection.getResponseCode();//得到响应代码
                responses.HEADERS = Connection.getHeaderFields();
                responses.URL = Connection.getURL().toString();
                responses.MESSAGE = Connection.getResponseMessage();//回应信息
                responses.InputStream = Connection.getInputStream();//创建输入流对象
                ByteArrayOutputStream bytearrayoutputstream = Read(responses.InputStream);
                responses.CONTENT = bytearrayoutputstream.toByteArray();
                responses.TEXT = bytearrayoutputstream.toString();
            } else {
                System.err.println("Is Protocol Exception:　" + protocol);
            }

        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return responses;
    }


    /**
     * http请求返回流的读取
     *
     * @param content 内容
     * @return 结果
     */
    public ByteArrayOutputStream Read(InputStream content) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        try {
            while (-1 != (len = content.read(buffer))) {
                baos.write(buffer, 0, len);
                baos.flush();
            }
            return baos;
        } catch (IOException e) {
            e.printStackTrace();
            return baos;
        }
    }
}

