package io.github.ibony.ats.common.okhttp;

import io.github.ibony.ats.utils.UrlArgEncode;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.json.JSONObject;

import javax.net.ssl.*;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by bony on 2017-06-26.=
 */
public class Requests {
    public boolean IS_PROXY = false;//是否代理
    public String PROXY_HOST = null;//代理地址
    public int PROXY_PROT = 0;//是否端口
    public Map<String, String> HRADER;//请求头
    public String URL;//请求URL
    OkHttpClient httpClient = null;
    OkHttpClient httpsClient = null;

    public Requests() {
        initHttpsClient();
        initHttpClient();
    }

    /**
     * 初始化THHPS
     */
    void initHttpsClient() {
        try {
            HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier() {
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            X509TrustManager trustManager = new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    X509Certificate[] x509Certificates = new X509Certificate[0];
                    return x509Certificates;
                }
            };
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            httpsClient = new OkHttpClient().newBuilder().sslSocketFactory(sc.getSocketFactory(), trustManager).hostnameVerifier(DO_NOT_VERIFY).build();
//            if (IS_PROXY==true){
//                httpClient.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY_HOST, PROXY_PROT)));
//                httpsClient.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY_HOST, PROXY_PROT)));
//            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 初始化THHP
     */
    void initHttpClient() {
        httpClient = new OkHttpClient();
    }


    /**
     * 简化封装的HttpsGet方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @return Response对象
     */
    public Response HttpsGet(String url, Map<String, String> header, JSONObject parame) {
        return get(url, header, parame, "https");
    }

    /**
     * 简化封装的HttpGet方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @return Response对象
     */
    public Response HttpGet(String url, Map<String, String> header, JSONObject parame) {
        return get(url, header, parame, "http");
    }

    /**
     * 简化封装的HttpsPost方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @param body JSONObject参数对象
     * @return Response对象
     */
    public Response HttpsPost(String url, Map<String, String> header, JSONObject parame, JSONObject body) {
        return post(url, header, parame, body, "https");
    }

    /**
     *
     * 简化封装的HttpPost方法
     *
     * @param url    链接/地址
     * @param header 请求头
     * @param parame JSONObject参数对象
     * @param body 参数
     * @return Responsem对象
     */
    public Response HttpPost(String url, Map<String, String> header, JSONObject parame, JSONObject body) {
        return post(url, header, parame, body, "http");
    }

    public String getUrlArgs(JSONObject parame) {
        return parame.toString();
    }

    /**
     * 简化封装的get方法
     *
     * @param url      链接/地址
     * @param header   请求头
     * @param parame   JSONObject参数对象
     * @param protocol 请求协议类型 HTTP/HTTPS
     * @return InputStream对象
     */
    private Response get(String url, Map<String, String> header, JSONObject parame, String protocol) {
        this.HRADER = header;
        httpClient.proxySelector();
        Request.Builder requestBuiler = new Request.Builder().url(new UrlArgEncode().get(url, parame));
//        requestBuiler.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("127.0.0.1", 8888)));
        Iterator<Map.Entry<String, String>> entries = this.HRADER.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            requestBuiler.addHeader(entry.getKey(), entry.getValue());
        }
        return clientCall(requestBuiler, protocol);
    }

    /**
     * 简化封装的post方法
     *
     * @param url      链接/地址
     * @param header   请求头
     * @param parame   JSONObject参数对象
     * @param protocol 请求协议类型 HTTP/HTTPS
     * @return Response对象
     */
    private Response post(String url, Map<String, String> header, JSONObject parame, JSONObject body, String protocol) {
        this.HRADER = header;
        FormBody.Builder builder = new FormBody.Builder();
        for (Iterator it = body.keys(); it.hasNext(); ) {
            String key = (String) it.next();
            try {
                builder.add(key, body.get(key).toString());
            } catch (Exception e) {}
        }
        Request.Builder requestBuiler = new Request.Builder().url(new UrlArgEncode().get(url, parame)).post(builder.build());
        Iterator<Map.Entry<String, String>> entries = this.HRADER.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            requestBuiler.addHeader(entry.getKey(), entry.getValue());
        }
        return clientCall(requestBuiler, protocol);
    }

    public Response clientCall(Request.Builder requestBuiler, String protocol) {
        Response responses = new Response();
        try {
            okhttp3.Response response;
            if (protocol.equals("http")) response = httpClient.newCall(requestBuiler.build()).execute();
            else response = httpsClient.newCall(requestBuiler.build()).execute();
            if (!response.isSuccessful()) throw new IOException("Unexpected code " + response);
            responses.HEADERS = response.headers();
            responses.CONTENT = response.body().bytes();
//            responses.TEXT =  (String)response.body().string();
            responses.MESSAGE = response.message();
            responses.CODE = response.code();
        } catch (Exception e) {

        }
        return responses;
    }
}
