package io.github.ibony.ats.report;

import org.json.JSONObject;

/**
 * Created by bony on 2020-07-23.
 */
public class CaseInfo {
    String module;
    String id;
    String caseName;
    String action;
    String expected;
    String actual;
    boolean result;
    String msg = "";
    String annexPath = "";

    public CaseInfo(String module, String caseName, String action, String expected, String actual, boolean result, String msg) {
        this.module = module;
        this.caseName = caseName;
        this.action = action;
        this.expected = expected;
        this.actual = actual;
        this.result = result;
        this.msg = msg;
    }

    public CaseInfo(String module, String caseName, String action, String expected, String actual, boolean result) {
        this(module, caseName, action, expected, actual, result, "");
    }

    JSONObject toJsonObject() {
        JSONObject caseInfo = new JSONObject();
        caseInfo.put("id", id);
        caseInfo.put("caseName", caseName);
        caseInfo.put("module", module);
        caseInfo.put("action", action);
        caseInfo.put("expected", expected);
        caseInfo.put("actual", actual);
        caseInfo.put("result", result);
        caseInfo.put("msg", msg);
        caseInfo.put("annexPath", annexPath);
        return caseInfo;
    }

    @Override
    public String toString() {
        return toJsonObject().toString();
    }
    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getExpected() {
        return expected;
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public String getActual() {
        return actual;
    }

    public void setActual(String actual) {
        this.actual = actual;
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getAnnexPath() {
        return annexPath;
    }

    protected void setAnnexPath(String annexPath) {
        this.annexPath = annexPath;
    }
}
