package io.github.ibony.ats.report;

import org.json.JSONObject;

/**
 * Created by bony on 2020-08-31.
 */
public class ModuleStats {
    String name;
    long totalNumber;
    long passNumber;
    long failNumber;

    public ModuleStats(String name) {
        this.name = name;
        this.totalNumber = 0;
        this.passNumber = 0;
        this.failNumber = 0;
    }
    public ModuleStats(CaseInfo caseInfo) {
        this(caseInfo.getModule());
        calcAdd(caseInfo);
    }

    public String getName() {
        return name;
    }

    public long getTotalNumber() {
        return totalNumber;
    }

    public long getPassNumber() {
        return passNumber;
    }

    public long getFailNumber() {
        return failNumber;
    }

    protected void calcAdd(CaseInfo caseInfo) {
        totalNumber++;
        if (caseInfo.isResult()) passNumber++;
        else failNumber++;
    }

    JSONObject toJsonObject() {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.put("totalNumber", totalNumber);
        json.put("passNumber", passNumber);
        json.put("failNumber", failNumber);
        return json;
    }

    @Override
    public String toString() {
        return toJsonObject().toString();
    }
}
