package io.github.ibony.ats.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;

/***
 * Created by bony on 2017-09-13.
 ***/
public class BaseUtil {

	public static boolean isInteger(String str) {
		if (isEmpty(str)) {
			return false;
		} else {
			Pattern pattern = Pattern.compile("[0-9]\\d*");
			return pattern.matcher(str.trim()).matches();
		}
	}

	public static boolean isEmpty(String s) {
		if (s != null && !"".equals(s)) {
			return false;
		} else {
			for (int i = 0; i < s.length(); i++) {
				if (!Character.isWhitespace(s.charAt(i))) {
					return false;
				}
			}
		}
		return true;
	}


	public static Double sub(Double v1, Double v2) {
		BigDecimal b1 = new BigDecimal(v1.toString());
		BigDecimal b2 = new BigDecimal(v2.toString());
		return b1.subtract(b2).doubleValue();
	}

	public static int getAll(ArrayList<Integer> data) {
		int count = 0;
		for (int i = 0; i < data.size(); i++) {
			count += data.get(i);
		}
		return count;
	}

	public static int getMin(ArrayList<Integer> data) {
		if(data.size()>0)
		{
			return Collections.min(data);
		}
		return -1;
	}

	public static int getMax(ArrayList<Integer> data) {
		if(data.size()>0)
		{
			return Collections.max(data);
		}
		return -1;
	}

	public static int getAvg(ArrayList<Integer> data) {
		if(data.size()!=0)
		{
			int count = 0;
			for (int i = 0; i < data.size(); i++) {
				count += data.get(i);
			}
			return count / data.size();
		}
		return -1;
	}
	public static int getAvg(HashMap<String,Integer> map)
	{
		int count=0;
		if(map.size()>=0)
		{
			Collection<Integer> values = map.values();
			for(int value : values)
			{
				count+=value;
			}
			return count/values.size();
		}
		return -1;
	}
	public static int getMax(HashMap<String,Integer> map) {
		if(map.size()>0)
		{
			Collection<Integer> values = map.values();
			return Collections.max(values);
		}
		return -1;
	}
	public static int getMin(HashMap<String,Integer> map) {
		if(map.size()>0)
		{
			Collection<Integer> values = map.values();
			return Collections.min(values);
		}
		return -1;
	}
}
