package io.github.ibony.ats.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * <P>Title: ClassUtil.java</P>
 * <P>Description: 类操作工具类</P>
 * Created by bony on 2017-07-28.
 */
public class ClassUtil {

    /**
     * 根据路径获取类
     * @param pack
     * @param name
     * @return
     */
//    public Class getClass(String pack,String name){
//
//        ClassLoader classLoader = new ClassLoader( new String[] { "D:\\Cheiron\\Test\\bin" });//类根路径
//        Class<?> cl = classLoader.loadClass("org.apache.commons.lang.StringUtils");//类名
//        Method method = cl.getMethod("split", String.class, String.class);//类的方法
//        try {
//            URLDecoder.decode(
//                    Thread.currentThread().getContextClassLoader().getResources(pack.replace('.', '/')).nextElement().getFile(),
//                    "UTF-8"
//            );
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }

    /**
     * 从包package中获取所有的Class
     *
     * @param pack 包
     * @return class列表
     */
    public static Set<Class<?>> getClasses(String pack) {

        // 第一个class类的集合
        Set<Class<?>> classes = new LinkedHashSet<Class<?>>();
        // 是否循环迭代
        boolean recursive = true;
        // 获取包的名字 并进行替换
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        // 定义一个枚举的集合 并进行循环来处理这个目录下的things
        Enumeration<URL> dirs;
        try {
            dirs = Thread.currentThread()
                    .getContextClassLoader()
                    .getResources(packageDirName);
            // 循环迭代下去
            while (dirs.hasMoreElements()) {
                // 获取下一个元素
                URL url = dirs.nextElement();
                // 得到协议的名称
                String protocol = url.getProtocol();
                // 如果是以文件的形式保存在服务器上
                if ("file".equals(protocol)) {
                    // 获取包的物理路径
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    // 以文件的方式扫描整个包下的文件 并添加到集合中
                    findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                } else if ("jar".equals(protocol)) {
                    // 如果是jar包文件
                    // 定义一个JarFile
                    JarFile jar;
                    try {
                        jar = ((JarURLConnection) url.openConnection()).getJarFile();// 获取jar
                        Enumeration<JarEntry> entries = jar.entries();// 从此jar包 得到一个枚举类
                        while (entries.hasMoreElements()) {// 同样的进行循环迭代
                            JarEntry entry = entries.nextElement();// 获取jar里的一个实体 可以是目录 和一些jar包里的其他文件 如META-INF等文件
                            String name = entry.getName();
                            if (name.charAt(0) == '/') {// 如果是以/开头的
                                name = name.substring(1);// 获取后面的字符串
                            }
                            if (name.startsWith(packageDirName)) {// 如果前半部分和定义的包名相同
                                int idx = name.lastIndexOf('/');
                                if (idx != -1) { // 如果以"/"结尾 是一个包
                                    packageName = name.substring(0, idx).replace('/', '.');// 获取包名 把"/"替换成"."
                                }
                                if ((idx != -1) || recursive) { // 如果可以迭代下去 并且是一个包
                                    if (name.endsWith(".class") && !entry.isDirectory()) {// 如果是一个.class文件 而且不是目录

                                        String className = name.substring(// 去掉后面的".class" 获取真正的类名
                                                packageName.length() + 1, name.length() - 6);
                                        try {
                                            classes.add(Class.forName(packageName + '.' + className));// 添加到classes
                                        } catch (ClassNotFoundException e) {
                                            e.printStackTrace();// log// .error("添加用户自定义视图类错误 找不到此类的.class文件");
                                        }
                                    }
                                }
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace(); // log.error("在扫描用户定义视图时从jar包获取文件出错");
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return classes;
    }

    /**
     * 以文件的形式来获取包下的所有Class
     *
     * @param packageName 包名
     * @param packagePath 包路径
     * @param recursive recursive
     * @param classes classes
     */
    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File dir = new File(packagePath);// 获取此包的目录 建立一个File
        if (!dir.exists() || !dir.isDirectory()) {// 如果不存在或者 也不是目录就直接返回
            // log.warn("用户定义包名 " + packageName + " 下没有任何文件");
            return;
        }

        File[] dirfiles = dir.listFiles(new FileFilter() {// 如果存在 就获取包下的所有文件 包括目录
            public boolean accept(File file) {// 自定义过滤规则 如果可以循环(包含子目录) 或则是以.class结尾的文件(编译好的java类文件)
                return (recursive && file.isDirectory()) ||
                        (file.getName().endsWith(".class"));
            }
        });
        for (File file : dirfiles) { // 循环所有文件
            if (file.isDirectory()) {// 如果是目录 则继续扫描
                findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
            } else {
                String className = file.getName().substring(0,// 如果是java类文件 去掉后面的.class 只留下类名
                        file.getName().length() - 6);
                try {
                    // 添加到集合中去
                    //classes.add(Class.forName(packageName + '.' + className));
                    //经过回复同学的提醒，这里用forName有一些不好，会触发static方法，
                    //没有使用classLoader的load干净
                    classes.add(Thread.currentThread()
                            .getContextClassLoader()
                            .loadClass(packageName + '.' + className));
                } catch (ClassNotFoundException e) {
                    // log.error("添加用户自定义视图类错误 找不到此类的.class文件");
                    e.printStackTrace();
                }
            }
        }
    }

}