package io.github.ibony.ats.utils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

public class ImageUtil {

    /**
     * 文字转图片
     *
     * @param str 文字
     * @param filePath 路径
     * @throws Exception 异常
     */
    public static void textToImage(String str, String filePath) throws Exception {
        int length = str.length();
        int width_size = (int) Math.ceil((float)length / Math.sqrt(length));
        int height_size = (int) Math.ceil((float)length / width_size)-1;
        int f_width = 144 / width_size; // 每行或者每个文字的宽度
        int f_height = f_width;// 每行或者每个文字的高度
        Font font = new Font("微软雅黑", Font.BOLD, f_width); // 字体大小
        int image_width = 144; // 每张图片的宽度
        int image_height = 144; // 每张图片的高度
        File outFile = new File(filePath);
        // 创建图片
        BufferedImage image = new BufferedImage(image_width, image_height, BufferedImage.TYPE_USHORT_565_RGB);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setClip(0, 0, image_width, image_height);
        graphics2D.setColor(Color.white); // 背景色白色
        graphics2D.fillRect(0, 0, image_width, image_height);
        graphics2D.setColor(Color.BLACK);//  字体颜色红色
        graphics2D.setFont(font);// 设置画笔字体
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB); // 抗锯齿
        int margins=(144-(height_size*f_height))/3;
        for (int i = 0; i <= height_size; i++) {
            int start_index = i * width_size;
            int end_index = (i + 1) * width_size;
            if (end_index > length) end_index = length;
            String subStr = str.substring(start_index, end_index);
            int y=(f_height/2)+f_height*(i)+margins;
//            System.out.println(String.format("%d,%d,%s",i,y,subStr));
            graphics2D.drawString(subStr, 1, y);
        }
        graphics2D.dispose(); // 释放资源
        ImageIO.write(image, "png", outFile);// 输出png图片
    }
}
