package io.github.ibony.ats.utils;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/***
 * Created by bony on 2017-09-13.
 ***/
public class StringUtil {

    /**
     * 判断是否是字母
     *
     * @param str 传入字符
     * @return 是字母返回true，否则返回false
     */
    public static boolean isEn(char str) {
        if(65<=str&&str<=90)return true;
        if(97<=str&&str<=122)return true;
        return false;
    }
    /**
     * 判断是否是特殊字符
     *
     * @param str 传入字符
     * @return 是特殊字符返回true，否则返回false
     */
    public static boolean isSpecial(char str) {
        if(32<=str&&str<=47)return true;
        if(58<=str&&str<=64)return true;
        if(123<=str&&str<=127)return true;
        return false;
    }

    private static final String SEP1 = "#";
    private static final String SEP2 = "|";


    public static String getBase64(String str) {
        byte[] b = null;
        String s = null;
        try {
            b = str.getBytes("utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (b != null) {
            s = new BASE64Encoder().encode(b);
        }
        return s;
    }

    public static String getFromBase64(String s) {
        byte[] b = null;
        String result = null;
        if (s != null) {
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                b = decoder.decodeBuffer(s);
                result = new String(b, "utf-8");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /**
     * List转换String
     *
     * @param list :需要转换的List
     * @return String转换后的字符串
     */
    public static String listToString(List<?> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                if (list.get(i) == null || list.get(i) == "") {
                    continue;
                }
                // 如果值是list类型则调用自己
                if (list.get(i) instanceof List) {
                    sb.append(listToString((List<?>) list.get(i)));
                    sb.append(SEP1);
                } else if (list.get(i) instanceof Map) {
                    sb.append(mapToString((Map<?, ?>) list.get(i)));
                    sb.append(SEP1);
                } else {
                    sb.append(list.get(i));
                    sb.append(SEP1);
                }
            }
        }
        return "L" + getBase64(sb.toString());
    }

    /**
     * Map转换String
     *
     * @param map :需要转换的Map
     * @return String转换后的字符串
     */
    public static String mapToString(Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        // 遍历map
        for (Object obj : map.keySet()) {
            if (obj == null) {
                continue;
            }
            Object key = obj;
            Object value = map.get(key);
            if (value instanceof List<?>) {
                sb.append(key.toString() + SEP1 + listToString((List<?>) value));
                sb.append(SEP2);
            } else if (value instanceof Map<?, ?>) {
                sb.append(key.toString() + SEP1
                        + mapToString((Map<?, ?>) value));
                sb.append(SEP2);
            } else {
                sb.append(key.toString() + SEP1 + value.toString());
                sb.append(SEP2);
            }
        }
        return "M" + getBase64(sb.toString());
    }

    /**
     * String转换Map
     *
     * @param mapStr :需要转换的字符串
     * @return Map 元素map
     */
    public static Map<String, String> stringToMap(String mapStr) {
        mapStr=mapStr.replaceAll("\\{|\\}", "");
        Map<String, String> map = new HashMap<>();
        String k=null;
        for (String str : mapStr.split(",")) {
            str=str.trim();
            if(str.contains("=")){
                String[] tmp = str.split("=");
                if(tmp.length>1){
                    map.put(tmp[0].trim(), tmp[1].trim());
                }else {
                    map.put(tmp[0].trim(), "");
                }
                k=tmp[0].trim();
            }else {
                if(k!=null){
                    //错误,分割处理
                    map.put(k,map.get(k)+","+str);
                }
            }
        }
        return map;
    }

    /**
     * String转换List
     *
     * @param listText :需要转换的文本
     * @return List 元素列表
     */
    public static List<Object> stringToList(String listText) {
        if (listText == null || listText.equals("")) {
            return null;
        }
        listText = listText.substring(1);

        listText = getFromBase64(listText);

        List<Object> list = new ArrayList<Object>();
        String[] text = listText.split(SEP1);
        for (String str : text) {
            if (str.charAt(0) == 'M') {
                Map<?, ?> map = stringToMap(str);
                list.add(map);
            } else if (str.charAt(0) == 'L') {
                List<?> lists = stringToList(str);
                list.add(lists);
            } else {
                list.add(str);
            }
        }
        return list;
    }


    /**
     * 判断字符串是否是纯汉字
     * PS：中文汉字的编码范围：[\u4e00-\u9fa5]
     *
     * @param c 需要判断的字符
     * @return 是汉字(true), 不是汉字(false)
     */
    public static boolean isChineseString(String c) {
        return c.matches("[\\u4e00-\\u9fa5]+");
    }
    /**
     * 判断一个字符是否是汉字
     * PS：中文汉字的编码范围：[\u4e00-\u9fa5]
     *
     * @param c 需要判断的字符
     * @return 是汉字(true), 不是汉字(false)
     */
    public static boolean isChineseChar(char c) {
        return String.valueOf(c).matches("[\\u4e00-\\u9fa5]+");
    }
}
