package io.github.ibony.ats.utils;

import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/***
 * Created by bony on 2017-09-13.
 ***/
public class Xml {
    private String xml;
    private Document document;

    /***
     *
     * @param file 文浩
     */
    public Xml(File file) {
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(file);
        } catch (DocumentException e) {
            //TODO Auto-generated catch block
            System.err.println("Xml Exception!!! \n" + e.getMessage());
            //e.printStackTrace();
        }
//        file.delete();
    }

    /**
     *
     * @param content 内容
     */
    public Xml(String content) {
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(new ByteArrayInputStream(content.getBytes("UTF-8")));
        } catch (Exception e) {
            //TODO Auto-generated catch block
            System.err.println("Xml Exception!!! \n" + e.getMessage());
            //e.printStackTrace();
        }
//        file.delete();
    }


    public Document getDocument() {
        return this.document;
    }

    /**
     * 获所有名为elementname的节点,对外函数
     * @param elementname 元素名称
     * @return Elements 元素列表
     */
    public ArrayList<Element> getElementAll(String elementname) {
        ArrayList<Element> elementlist = new ArrayList<Element>();
        return getElementlist(document.getRootElement(), elementname, elementlist);
    }

    /**
     *
     * 获所有名为elementname的节点,功能函数
     * @param element 元素
     * @param elementname 元素名称
     * @param elements 元素列表
     * @return 元素列表
     */
    private ArrayList<Element> getElementlist(Element element, String elementname, ArrayList<Element> elements) {
        try {
            List nodes = element.elements(elementname);
            for (Iterator it = nodes.iterator(); it.hasNext(); ) {
                Element elm = (Element) it.next();
                elements.add(elm);
//                System.out.println("node:::"+elm.attribute("class").getValue());
                getElementlist(elm, elementname, elements);
            }
        } catch (Exception e) {
            System.err.println("getElementlist Exception!!\n" + e.getMessage());
        }
        return elements;
    }

}
