/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.conf.AbstractRuntimeProperty;
import com.mysql.cj.conf.ConnectionUrl;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.jdbc.JdbcPropertySet;
import com.mysql.cj.jdbc.JdbcPropertySetImpl;
import com.mysql.cj.jdbc.MysqlDataSourceFactory;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MysqlDataSource
extends JdbcPropertySetImpl
implements DataSource,
Referenceable,
Serializable,
JdbcPropertySet {
    static final long serialVersionUID = -5515846944416881264L;
    protected static final NonRegisteringDriver mysqlDriver;
    protected transient PrintWriter logWriter = null;
    protected String databaseName = null;
    protected String encoding = null;
    protected String url = null;
    protected boolean explicitUrl = false;
    protected String hostName = null;
    protected int port = 3306;
    protected boolean explicitPort = false;
    protected String user = null;
    protected String password = null;
    protected String profileSQLString = "false";
    protected String description = "MySQL Connector/J Data Source";

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String userID, String pass) throws SQLException {
        Properties props = this.exposeAsProperties();
        if (userID != null) {
            props.setProperty(PropertyKey.USER.getKeyName(), userID);
        }
        if (pass != null) {
            props.setProperty(PropertyKey.PASSWORD.getKeyName(), pass);
        }
        return this.getConnection(props);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "";
    }

    @Override
    public void setLogWriter(PrintWriter output) throws SQLException {
        this.logWriter = output;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPort(int p) {
        this.port = p;
        this.explicitPort = true;
    }

    public int getPort() {
        return this.port;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPropertiesViaRef(Reference ref) throws SQLException {
        for (PropertyKey propKey : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.keySet()) {
            RuntimeProperty propToSet = this.getProperty(propKey);
            if (ref == null) continue;
            propToSet.initializeFrom(ref, null);
        }
        this.postInitialization();
    }

    @Override
    public Reference getReference() throws NamingException {
        String factoryName = MysqlDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr(PropertyKey.USER.getKeyName(), this.getUser()));
        ref.add(new StringRefAddr(PropertyKey.PASSWORD.getKeyName(), this.password));
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("port", "" + this.getPort()));
        ref.add(new StringRefAddr("explicitPort", String.valueOf(this.explicitPort)));
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("explicitUrl", String.valueOf(this.explicitUrl)));
        for (PropertyKey propKey : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.keySet()) {
            RuntimeProperty propToStore = this.getProperty(propKey);
            String val = propToStore.getStringValue();
            if (val == null) continue;
            ref.add(new StringRefAddr(propToStore.getPropertyDefinition().getName(), val));
        }
        return ref;
    }

    public void setServerName(String serverName) {
        this.hostName = serverName;
    }

    public String getServerName() {
        return this.hostName != null ? this.hostName : "";
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setUrl(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            StringBuilder sbUrl = new StringBuilder(ConnectionUrl.Type.SINGLE_CONNECTION.getScheme());
            sbUrl.append("//").append(this.getServerName());
            try {
                if (this.explicitPort || !this.getBooleanRuntimeProperty(PropertyKey.dnsSrv.getKeyName())) {
                    sbUrl.append(":").append(this.getPort());
                }
            }
            catch (SQLException e) {
                sbUrl.append(":").append(this.getPort());
            }
            sbUrl.append("/").append(this.getDatabaseName());
            return sbUrl.toString();
        }
        return this.url;
    }

    public void setUser(String userID) {
        this.user = userID;
    }

    public String getUser() {
        return this.user;
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String jdbcUrlToUse = this.explicitUrl ? this.url : this.getUrl();
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(jdbcUrlToUse, null);
        Properties urlProps = connUrl.getConnectionArgumentsAsProperties();
        urlProps.remove(PropertyKey.HOST.getKeyName());
        urlProps.remove(PropertyKey.PORT.getKeyName());
        urlProps.remove(PropertyKey.DBNAME.getKeyName());
        urlProps.stringPropertyNames().stream().forEach(k -> props.setProperty((String)k, urlProps.getProperty((String)k)));
        return mysqlDriver.connect(jdbcUrlToUse, props);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected String getStringRuntimeProperty(String name) throws SQLException {
        return this.getStringProperty(name).getValue();
    }

    protected void setStringRuntimeProperty(String name, String value) throws SQLException {
        ((AbstractRuntimeProperty)this.getStringProperty(name)).setValueInternal(value, null, null);
    }

    protected boolean getBooleanRuntimeProperty(String name) throws SQLException {
        return this.getBooleanProperty(name).getValue();
    }

    protected void setBooleanRuntimeProperty(String name, boolean value) throws SQLException {
        ((AbstractRuntimeProperty)this.getBooleanProperty(name)).setValueInternal(value, null, null);
    }

    protected int getIntegerRuntimeProperty(String name) throws SQLException {
        return this.getIntegerProperty(name).getValue();
    }

    protected void setIntegerRuntimeProperty(String name, int value) throws SQLException {
        ((AbstractRuntimeProperty)this.getIntegerProperty(name)).setValueInternal(value, null, null);
    }

    protected long getLongRuntimeProperty(String name) throws SQLException {
        return this.getLongProperty(name).getValue();
    }

    protected void setLongRuntimeProperty(String name, long value) throws SQLException {
        ((AbstractRuntimeProperty)this.getLongProperty(name)).setValueInternal(value, null, null);
    }

    protected int getMemorySizeRuntimeProperty(String name) throws SQLException {
        return this.getMemorySizeProperty(name).getValue();
    }

    protected void setMemorySizeRuntimeProperty(String name, int value) throws SQLException {
        ((AbstractRuntimeProperty)this.getMemorySizeProperty(name)).setValueInternal(value, null, null);
    }

    protected String getEnumRuntimeProperty(String name) throws SQLException {
        return this.getEnumProperty(name).getStringValue();
    }

    protected void setEnumRuntimeProperty(String name, String value) throws SQLException {
        ((AbstractRuntimeProperty)this.getEnumProperty(name)).setValueInternal(value, null);
    }

    @Override
    public Properties exposeAsProperties() {
        Properties props = new Properties();
        for (PropertyKey propKey : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.keySet()) {
            RuntimeProperty propToGet = this.getProperty(propKey);
            String propValue = propToGet.getStringValue();
            if (propValue == null || !propToGet.isExplicitlySet()) continue;
            props.setProperty(propToGet.getPropertyDefinition().getName(), propValue);
        }
        return props;
    }

    static {
        try {
            mysqlDriver = new NonRegisteringDriver();
        }
        catch (Exception E) {
            throw new RuntimeException(Messages.getString("MysqlDataSource.0"));
        }
    }
}

