/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.ha;

import com.mysql.cj.Messages;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.ha.LoadBalancedConnection;
import com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import com.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import java.sql.SQLException;

public class LoadBalancedMySQLConnection
extends MultiHostMySQLConnection
implements LoadBalancedConnection {
    public LoadBalancedMySQLConnection(LoadBalancedConnectionProxy proxy) {
        super(proxy);
    }

    @Override
    public LoadBalancedConnectionProxy getThisAsProxy() {
        return (LoadBalancedConnectionProxy)super.getThisAsProxy();
    }

    @Override
    public void close() throws SQLException {
        this.getThisAsProxy().doClose();
    }

    @Override
    public void ping() throws SQLException {
        this.ping(true);
    }

    @Override
    public void ping(boolean allConnections) throws SQLException {
        if (allConnections) {
            this.getThisAsProxy().doPing();
        } else {
            this.getActiveMySQLConnection().ping();
        }
    }

    @Override
    public boolean addHost(String host) throws SQLException {
        return this.getThisAsProxy().addHost(host);
    }

    @Override
    public void removeHost(String host) throws SQLException {
        this.getThisAsProxy().removeHost(host);
    }

    @Override
    public void removeHostWhenNotInUse(String host) throws SQLException {
        this.getThisAsProxy().removeHostWhenNotInUse(host);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.getExceptionInterceptor());
        }
    }
}

