/*
 * Decompiled with CFR 0.152.
 */
package demo.x.devapi;

import com.mysql.cj.xdevapi.Collection;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DbDocImpl;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.JsonNumber;
import com.mysql.cj.xdevapi.JsonString;
import com.mysql.cj.xdevapi.Schema;
import com.mysql.cj.xdevapi.Session;
import com.mysql.cj.xdevapi.SessionFactory;

public class DevApiSample {
    public static void main(String[] args) {
        Session session = new SessionFactory().getSession("mysqlx://localhost:33060/test?user=user&password=password1234");
        System.err.println("Connected!");
        Schema schema = session.getDefaultSchema();
        System.err.println("Default schema is: " + schema);
        DevApiSample.documentWalkthrough(schema);
    }

    public static void documentWalkthrough(Schema schema) {
        Collection coll = schema.createCollection("myBooks", true);
        DbDoc newDoc = new DbDocImpl().add("isbn", new JsonString().setValue("12345"));
        newDoc.add("title", new JsonString().setValue("Effi Briest"));
        newDoc.add("author", new JsonString().setValue("Theodor Fontane"));
        newDoc.add("currentlyReadingPage", new JsonNumber().setValue(String.valueOf(42)));
        coll.add(newDoc).execute();
        DocResult docs = (DocResult)coll.find("$.title = 'Effi Briest' and $.currentlyReadingPage > 10").execute();
        DbDoc book = (DbDoc)docs.next();
        System.err.println("Currently reading " + ((JsonString)book.get("title")).getString() + " on page " + ((JsonNumber)book.get("currentlyReadingPage")).getInteger());
        coll.modify("$.isbn = 12345").set("$.currentlyReadingPage", ((JsonNumber)book.get("currentlyReadingPage")).getInteger() + 1).execute();
        docs = (DocResult)coll.find("$.title = 'Effi Briest' and $.currentlyReadingPage > 10").execute();
        book = (DbDoc)docs.next();
        System.err.println("Currently reading " + ((JsonString)book.get("title")).getString() + " on page " + ((JsonNumber)book.get("currentlyReadingPage")).getInteger());
        coll.remove("true").execute();
        System.err.println("Number of books in collection: " + coll.count());
        schema.dropCollection(coll.getName());
    }
}

