/*
 * Decompiled with CFR 0.152.
 */
package documentation;

import com.mysql.cj.exceptions.MysqlErrorNumbers;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeMap;

public class ErrorMappingsDocGenerator {
    public static void main(String[] args) throws Exception {
        ErrorMappingsDocGenerator.dumpSqlStatesMappingsAsXml();
    }

    public static void dumpSqlStatesMappingsAsXml() throws Exception {
        TreeMap<Integer, Integer> allErrorNumbers = new TreeMap<Integer, Integer>();
        HashMap<Object, String> mysqlErrorNumbersToNames = new HashMap<Object, String>();
        for (Integer errorNumber : MysqlErrorNumbers.mysqlToSql99State.keySet()) {
            allErrorNumbers.put(errorNumber, errorNumber);
        }
        Field[] possibleFields = MysqlErrorNumbers.class.getDeclaredFields();
        for (int i = 0; i < possibleFields.length; ++i) {
            String fieldName = possibleFields[i].getName();
            if (!fieldName.startsWith("ER_")) continue;
            mysqlErrorNumbersToNames.put(possibleFields[i].get(null), fieldName);
        }
        System.out.println("<ErrorMappings>");
        for (Integer errorNumber : allErrorNumbers.keySet()) {
            String sql92State = MysqlErrorNumbers.mysqlToSql99(errorNumber);
            System.out.println("   <ErrorMapping mysqlErrorNumber=\"" + errorNumber + "\" mysqlErrorName=\"" + (String)mysqlErrorNumbersToNames.get(errorNumber) + "\" legacySqlState=\"\" sql92SqlState=\"" + (sql92State == null ? "" : sql92State) + "\"/>");
        }
        System.out.println("</ErrorMappings>");
    }
}

