/*
 * Decompiled with CFR 0.152.
 */
package documentation;

import com.mysql.cj.conf.PropertyDefinition;
import com.mysql.cj.conf.PropertyDefinitions;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PropertiesDocGenerator {
    public static void main(String[] args) {
        System.out.println(PropertiesDocGenerator.exposeAsXml());
    }

    public static String exposeAsXml() {
        StringBuilder xmlBuf = new StringBuilder();
        xmlBuf.append("<ConnectionProperties>");
        int numCategories = PropertyDefinitions.PROPERTY_CATEGORIES.length;
        HashMap<String, XmlMap> propertyListByCategory = new HashMap<String, XmlMap>();
        for (int i = 0; i < numCategories; ++i) {
            propertyListByCategory.put(PropertyDefinitions.PROPERTY_CATEGORIES[i], new XmlMap());
        }
        for (PropertyDefinition<?> pdef : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.values()) {
            XmlMap sortMaps = (XmlMap)propertyListByCategory.get(pdef.getCategory());
            int n = pdef.getOrder();
            if (n == Integer.MIN_VALUE) {
                sortMaps.alpha.put(pdef.getName(), pdef);
                continue;
            }
            Integer order = n;
            Map<String, PropertyDefinition<?>> orderMap = sortMaps.ordered.get(order);
            if (orderMap == null) {
                orderMap = new TreeMap();
                sortMaps.ordered.put(order, orderMap);
            }
            orderMap.put(pdef.getName(), pdef);
        }
        for (int j = 0; j < numCategories; ++j) {
            XmlMap sortMaps = (XmlMap)propertyListByCategory.get(PropertyDefinitions.PROPERTY_CATEGORIES[j]);
            xmlBuf.append("\n <PropertyCategory name=\"");
            xmlBuf.append(PropertyDefinitions.PROPERTY_CATEGORIES[j]);
            xmlBuf.append("\">");
            for (Map<String, PropertyDefinition<?>> map : sortMaps.ordered.values()) {
                for (PropertyDefinition<?> pdef : map.values()) {
                    xmlBuf.append("\n  <Property name=\"");
                    xmlBuf.append(pdef.getName());
                    xmlBuf.append("\" default=\"");
                    if (pdef.getDefaultValue() != null) {
                        xmlBuf.append(pdef.getDefaultValue());
                    }
                    xmlBuf.append("\" sortOrder=\"");
                    xmlBuf.append(pdef.getOrder());
                    xmlBuf.append("\" since=\"");
                    xmlBuf.append(pdef.getSinceVersion());
                    xmlBuf.append("\">\n");
                    xmlBuf.append("    ");
                    String escapedDescription = pdef.getDescription();
                    escapedDescription = escapedDescription.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                    xmlBuf.append(escapedDescription);
                    xmlBuf.append("\n  </Property>");
                }
            }
            for (PropertyDefinition propertyDefinition : sortMaps.alpha.values()) {
                xmlBuf.append("\n  <Property name=\"");
                xmlBuf.append(propertyDefinition.getName());
                xmlBuf.append("\" default=\"");
                if (propertyDefinition.getDefaultValue() != null) {
                    xmlBuf.append(propertyDefinition.getDefaultValue());
                }
                xmlBuf.append("\" sortOrder=\"alpha\" since=\"");
                xmlBuf.append(propertyDefinition.getSinceVersion());
                xmlBuf.append("\">\n");
                xmlBuf.append("    ");
                xmlBuf.append(propertyDefinition.getDescription());
                xmlBuf.append("\n  </Property>");
            }
            xmlBuf.append("\n </PropertyCategory>");
        }
        xmlBuf.append("\n</ConnectionProperties>");
        return xmlBuf.toString();
    }

    static class XmlMap {
        protected Map<Integer, Map<String, PropertyDefinition<?>>> ordered = new TreeMap();
        protected Map<String, PropertyDefinition<?>> alpha = new TreeMap();

        XmlMap() {
        }
    }
}

