/*
 * Decompiled with CFR 0.152.
 */
package instrumentation;

import com.mysql.cj.conf.BooleanPropertyDefinition;
import com.mysql.cj.conf.EnumPropertyDefinition;
import com.mysql.cj.conf.IntegerPropertyDefinition;
import com.mysql.cj.conf.LongPropertyDefinition;
import com.mysql.cj.conf.MemorySizePropertyDefinition;
import com.mysql.cj.conf.PropertyDefinition;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.StringPropertyDefinition;
import com.mysql.cj.jdbc.MysqlDataSource;
import java.util.Collection;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.DuplicateMemberException;

public class AddMethods {
    private static boolean verbose = false;

    public static void main(String[] args) throws Exception {
        System.out.println("Applying AddMethods.");
        verbose = "true".equalsIgnoreCase(args[1]);
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath(args[0]);
        AddMethods.sysOut("---");
        CtClass clazz = pool.get(MysqlDataSource.class.getName());
        AddMethods.sysOut("Add properties setters/getters to " + clazz.getName());
        AddMethods.addPropertiesGettersSetters(clazz, PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.values());
        clazz.writeFile(args[0]);
    }

    private static void sysOut(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private static void addPropertiesGettersSetters(CtClass clazz, Collection<PropertyDefinition<?>> propertyDefinitions) throws Exception {
        for (PropertyDefinition<?> def : propertyDefinitions) {
            String pname;
            if (def.getCategory().equals(PropertyDefinitions.CATEGORY_XDEVAPI)) continue;
            String string = pname = def.hasCcAlias() ? def.getCcAlias() : def.getName();
            if (def instanceof StringPropertyDefinition) {
                AddMethods.addGetter(clazz, pname, String.class.getName(), "getStringRuntimeProperty");
                AddMethods.addSetter(clazz, pname, String.class.getName(), "setStringRuntimeProperty");
                continue;
            }
            if (def instanceof BooleanPropertyDefinition) {
                AddMethods.addGetter(clazz, pname, Boolean.TYPE.getName(), "getBooleanRuntimeProperty");
                AddMethods.addSetter(clazz, pname, Boolean.TYPE.getName(), "setBooleanRuntimeProperty");
                continue;
            }
            if (def instanceof IntegerPropertyDefinition) {
                AddMethods.addGetter(clazz, pname, Integer.TYPE.getName(), "getIntegerRuntimeProperty");
                AddMethods.addSetter(clazz, pname, Integer.TYPE.getName(), "setIntegerRuntimeProperty");
                continue;
            }
            if (def instanceof LongPropertyDefinition) {
                AddMethods.addGetter(clazz, pname, Long.TYPE.getName(), "getLongRuntimeProperty");
                AddMethods.addSetter(clazz, pname, Long.TYPE.getName(), "setLongRuntimeProperty");
                continue;
            }
            if (def instanceof MemorySizePropertyDefinition) {
                AddMethods.addGetter(clazz, pname, Integer.TYPE.getName(), "getMemorySizeRuntimeProperty");
                AddMethods.addSetter(clazz, pname, Integer.TYPE.getName(), "setMemorySizeRuntimeProperty");
                continue;
            }
            if (def instanceof EnumPropertyDefinition) {
                AddMethods.addGetter(clazz, pname, String.class.getName(), "getEnumRuntimeProperty");
                AddMethods.addSetter(clazz, pname, "java.lang.String", "setEnumRuntimeProperty");
                continue;
            }
            throw new Exception("Unknown " + def.getName() + " property type.");
        }
    }

    private static void addGetter(CtClass clazz, String pname, String paramType, String getPropertyMethod) throws Exception {
        String mname = "get" + pname.substring(0, 1).toUpperCase() + pname.substring(1);
        String mbody = "public " + paramType + " " + mname + "() throws java.sql.SQLException { return " + getPropertyMethod + "(\"" + pname + "\");}";
        AddMethods.sysOut(mbody);
        try {
            CtMethod m = CtNewMethod.make((String)mbody, (CtClass)clazz);
            clazz.addMethod(m);
            AddMethods.sysOut(m.toString());
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
    }

    private static void addSetter(CtClass clazz, String pname, String paramType, String setPropertyMethod) throws Exception {
        String mname = "set" + pname.substring(0, 1).toUpperCase() + pname.substring(1);
        String mbody = "public void " + mname + "(" + paramType + " value) throws java.sql.SQLException { " + setPropertyMethod + "(\"" + pname + "\", value);}";
        AddMethods.sysOut(mbody);
        try {
            CtMethod m = CtNewMethod.make((String)mbody, (CtClass)clazz);
            clazz.addMethod(m);
            AddMethods.sysOut(m.toString());
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
    }
}

