/*
 * Decompiled with CFR 0.152.
 */
package instrumentation;

import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.ConnectionWrapper;
import java.sql.Savepoint;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class CommonChecks {
    private static boolean verbose = false;

    public static void main(String[] args) throws Exception {
        System.out.println("Applying CommonChecks.");
        verbose = "true".equalsIgnoreCase(args[1]);
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath(args[0]);
        CtClass ctClazz = pool.get(Class.class.getName());
        CtClass ctBool = pool.get(Boolean.TYPE.getName());
        CtClass ctInt = pool.get(Integer.TYPE.getName());
        CtClass ctIntArray = pool.get(int[].class.getName());
        CtClass ctMap = pool.get(Map.class.getName());
        CtClass ctObjectArray = pool.get(Object[].class.getName());
        CtClass ctSavepoint = pool.get(Savepoint.class.getName());
        CtClass ctString = pool.get(String.class.getName());
        CtClass ctStringArray = pool.get(String[].class.getName());
        CtClass clazz = pool.get(ConnectionImpl.class.getName());
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctInt, ctInt, ctBool}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createStatement", new CtClass[]{ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("isWrapperFor", new CtClass[]{ctClazz}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setReadOnly", new CtClass[]{ctBool}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("versionMeetsMinimum", new CtClass[]{ctInt, ctInt, ctInt}));
        clazz.writeFile(args[0]);
        clazz = pool.get(ConnectionWrapper.class.getName());
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("changeUser", new CtClass[]{ctString, ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepare", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepare", new CtClass[]{ctString, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctIntArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctStringArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, ctInt, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("commit", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("clearWarnings", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createArrayOf", new CtClass[]{ctString, ctObjectArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createBlob", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createClob", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createNClob", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createStatement", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createStatement", new CtClass[]{ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createStatement", new CtClass[]{ctInt, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createSQLXML", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("createStruct", new CtClass[]{ctString, ctObjectArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getAutoCommit", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getCatalog", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getClientInfo", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getClientInfo", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getDatabase", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getHoldability", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getMetaData", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getTransactionIsolation", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getTypeMap", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("getWarnings", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("isReadOnly", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("isReadOnly", new CtClass[]{ctBool}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("nativeSQL", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareCall", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareCall", new CtClass[]{ctString, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareCall", new CtClass[]{ctString, ctInt, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString, ctIntArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString, ctInt, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("prepareStatement", new CtClass[]{ctString, ctStringArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("releaseSavepoint", new CtClass[]{ctSavepoint}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("resetServerState", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("rollback", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("rollback", new CtClass[]{ctSavepoint}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString, ctIntArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString, ctStringArray}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("serverPrepareStatement", new CtClass[]{ctString, ctInt, ctInt, ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setAutoCommit", new CtClass[]{ctBool}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setCatalog", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setDatabase", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setHoldability", new CtClass[]{ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setReadOnly", new CtClass[]{ctBool}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setSavepoint", new CtClass[0]));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setSavepoint", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setSchema", new CtClass[]{ctString}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setTransactionIsolation", new CtClass[]{ctInt}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("setTypeMap", new CtClass[]{ctMap}));
        CommonChecks.addClosedCheck(clazz.getDeclaredMethod("shutdownServer", new CtClass[0]));
        clazz.writeFile(args[0]);
    }

    private static void addClosedCheck(CtMethod m) throws Exception {
        CommonChecks.sysOut(m.toString());
        m.insertBefore("checkClosed();");
    }

    private static void sysOut(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }
}

