/*
 * Decompiled with CFR 0.152.
 */
package instrumentation;

import com.mysql.cj.QueryBindings;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.jdbc.Blob;
import com.mysql.cj.jdbc.BlobFromLocator;
import com.mysql.cj.jdbc.CallableStatement;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.Clob;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.ConnectionWrapper;
import com.mysql.cj.jdbc.DatabaseMetaDataUsingInfoSchema;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.JdbcStatement;
import com.mysql.cj.jdbc.MysqlConnectionPoolDataSource;
import com.mysql.cj.jdbc.MysqlDataSource;
import com.mysql.cj.jdbc.MysqlParameterMetadata;
import com.mysql.cj.jdbc.MysqlPooledConnection;
import com.mysql.cj.jdbc.MysqlSQLXML;
import com.mysql.cj.jdbc.MysqlSavepoint;
import com.mysql.cj.jdbc.MysqlXAConnection;
import com.mysql.cj.jdbc.MysqlXADataSource;
import com.mysql.cj.jdbc.MysqlXid;
import com.mysql.cj.jdbc.NClob;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import com.mysql.cj.jdbc.ServerPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.SuspendableXAConnection;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.LoadBalancedConnection;
import com.mysql.cj.jdbc.ha.LoadBalancedMySQLConnection;
import com.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import com.mysql.cj.jdbc.ha.ReplicationConnection;
import com.mysql.cj.jdbc.ha.ReplicationMySQLConnection;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.jdbc.result.UpdatableResultSet;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.Message;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;

public class TranslateExceptions {
    private static CtClass runTimeException = null;
    private static ClassPool pool = ClassPool.getDefault();
    private static Map<String, List<CtMethod>> processed = new TreeMap<String, List<CtMethod>>();
    private static String EXCEPTION_INTERCEPTOR_GETTER = "getExceptionInterceptor()";
    private static String EXCEPTION_INTERCEPTOR_MEMBER = "this.exceptionInterceptor";
    private static boolean verbose = false;

    public static void main(String[] args) throws Exception {
        System.out.println("Applying TranslateExceptions.");
        verbose = "true".equalsIgnoreCase(args[1]);
        pool.insertClassPath(args[0]);
        processed.clear();
        runTimeException = pool.get(CJException.class.getName());
        CtClass ctQueryBindings = pool.get(QueryBindings.class.getName());
        CtClass ctColumnDefinition = pool.get(ColumnDefinition.class.getName());
        CtClass ctLongArray = pool.get(long[].class.getName());
        CtClass ctJdbcConnection = pool.get(JdbcConnection.class.getName());
        CtClass ctMysqlSavepoint = pool.get(MysqlSavepoint.class.getName());
        CtClass ctProperties = pool.get(Properties.class.getName());
        CtClass ctResultSet = pool.get(ResultSet.class.getName());
        CtClass ctResultSetInternalMethods = pool.get(ResultSetInternalMethods.class.getName());
        CtClass ctStatement = pool.get(Statement.class.getName());
        CtClass ctStatementImpl = pool.get(StatementImpl.class.getName());
        CtClass ctString = pool.get(String.class.getName());
        CtClass ctMessageBody = pool.get(Message.class.getName());
        CtClass clazz = pool.get(Blob.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, java.sql.Blob.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(BlobFromLocator.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, java.sql.Blob.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(com.mysql.cj.jdbc.CallableStatement.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, CallableStatement.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcStatement.class, true, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkIsOutputParam", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkParameterIndexBounds", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkReadOnlyProcedure", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("convertGetProcedureColumnsToInternalDescriptors", new CtClass[]{ctResultSet}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("determineParameterTypes", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("fakeParameterTypes", new CtClass[]{CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("fixParameterName", new CtClass[]{ctString}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("generateParameterMap", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getNamedParamIndex", new CtClass[]{ctString, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getOutputParameters", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("mapOutputParameterIndexToRsIndex", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("retrieveOutParams", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setInOutParamsOnServer", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setOutParams", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(Clob.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, java.sql.Clob.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ConnectionImpl.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcConnection.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("clientPrepareStatement", new CtClass[]{ctString, CtClass.intType, CtClass.intType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("createNewIO", new CtClass[]{CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getMetaData", new CtClass[]{CtClass.booleanType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("handleAutoCommitDefaults", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setSavepoint", new CtClass[]{ctMysqlSavepoint}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("versionMeetsMinimum", new CtClass[]{CtClass.intType, CtClass.intType, CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("rollbackNoChecks", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setupServerForTruncationChecks", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(LoadBalancedMySQLConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, LoadBalancedConnection.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(MultiHostMySQLConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcConnection.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ReplicationMySQLConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ReplicationConnection.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ConnectionWrapper.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcConnection.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("clientPrepare", new CtClass[]{ctString}), EXCEPTION_INTERCEPTOR_MEMBER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("clientPrepare", new CtClass[]{ctString, CtClass.intType, CtClass.intType}), EXCEPTION_INTERCEPTOR_MEMBER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setClientInfo", new CtClass[]{ctString, ctString}), EXCEPTION_INTERCEPTOR_MEMBER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setClientInfo", new CtClass[]{ctProperties}), EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(com.mysql.cj.jdbc.DatabaseMetaData.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, DatabaseMetaData.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(DatabaseMetaDataUsingInfoSchema.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, DatabaseMetaData.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(NonRegisteringDriver.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, Driver.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(NClob.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, java.sql.NClob.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(CallableStatement.CallableStatementParamInfo.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ParameterMetaData.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlParameterMetadata.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ParameterMetaData.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ClientPreparedStatement.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, PreparedStatement.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcStatement.class, true, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("toString", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkBounds", new CtClass[]{CtClass.intType, CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkReadOnlySafeStatement", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeBatchedInserts", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeBatchSerially", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeInternal", new CtClass[]{CtClass.intType, ctMessageBody, CtClass.booleanType, CtClass.booleanType, ctColumnDefinition, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executePreparedBatchAsMultiStatement", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeUpdateInternal", new CtClass[]{CtClass.booleanType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeUpdateInternal", new CtClass[]{ctQueryBindings, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("generateMultiStatementForBatch", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getBytesRepresentation", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getParameterBindings", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("initializeFromQueryInfo", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("isNull", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("prepareBatchedInsertSQL", new CtClass[]{ctJdbcConnection, CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setRetrieveGeneratedKeys", new CtClass[]{CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ServerPreparedStatement.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, PreparedStatement.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcStatement.class, true, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("toString", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getBinding", new CtClass[]{CtClass.intType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeInternal", new CtClass[]{CtClass.intType, ctMessageBody, CtClass.booleanType, CtClass.booleanType, ctColumnDefinition, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("realClose", new CtClass[]{CtClass.booleanType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("serverExecute", new CtClass[]{CtClass.intType, CtClass.booleanType, ctColumnDefinition}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("serverPrepare", new CtClass[]{ctString}), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ResultSetImpl.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ResultSetInternalMethods.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(UpdatableResultSet.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ResultSetInternalMethods.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("generateStatements", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(ResultSetMetaData.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, java.sql.ResultSetMetaData.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlSavepoint.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, Savepoint.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(StatementImpl.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, JdbcStatement.class, false, EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("createResultSetUsingServerFetch", new CtClass[]{ctString}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("doPingInstead", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeInternal", new CtClass[]{ctString, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeBatchUsingMultiQueries", new CtClass[]{CtClass.booleanType, CtClass.intType, CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeUpdateInternal", new CtClass[]{ctString, CtClass.booleanType, CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("executeSimpleNonQuery", new CtClass[]{ctJdbcConnection, ctString}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("generatePingResultSet", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getBatchedGeneratedKeys", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getBatchedGeneratedKeys", new CtClass[]{ctStatement}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getGeneratedKeysInternal", new CtClass[]{CtClass.longType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getLastInsertID", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getLongUpdateCount", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getOpenResultSetCount", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getResultSetInternal", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("processMultiCountsAndKeys", new CtClass[]{ctStatementImpl, CtClass.intType, ctLongArray}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("removeOpenResultSet", new CtClass[]{ctResultSetInternalMethods}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("resetCancelledState", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setHoldResultsOpenOverClose", new CtClass[]{CtClass.booleanType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setResultSetConcurrency", new CtClass[]{CtClass.intType}), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("useServerFetch", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("checkCancelTimeout", new CtClass[0]), EXCEPTION_INTERCEPTOR_GETTER);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlSQLXML.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, SQLXML.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlConnectionPoolDataSource.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, ConnectionPoolDataSource.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlDataSource.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, DataSource.class);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getStringRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setStringRuntimeProperty", new CtClass[]{ctString, ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getBooleanRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setBooleanRuntimeProperty", new CtClass[]{ctString, CtClass.booleanType}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getIntegerRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setIntegerRuntimeProperty", new CtClass[]{ctString, CtClass.intType}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getLongRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setLongRuntimeProperty", new CtClass[]{ctString, CtClass.longType}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getMemorySizeRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setMemorySizeRuntimeProperty", new CtClass[]{ctString, CtClass.intType}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("getEnumRuntimeProperty", new CtClass[]{ctString}), null);
        TranslateExceptions.catchRuntimeException(clazz, clazz.getDeclaredMethod("setEnumRuntimeProperty", new CtClass[]{ctString, ctString}), null);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlPooledConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, PooledConnection.class, false, EXCEPTION_INTERCEPTOR_MEMBER);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlXAConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, XAConnection.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(SuspendableXAConnection.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, XAConnection.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlXADataSource.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, DataSource.class);
        TranslateExceptions.instrumentJdbcMethods(clazz, XADataSource.class);
        clazz.writeFile(args[0]);
        clazz = pool.get(MysqlXid.class.getName());
        TranslateExceptions.instrumentJdbcMethods(clazz, Xid.class);
        clazz.writeFile(args[0]);
    }

    private static void instrumentJdbcMethods(CtClass cjClazz, Class<?> jdbcClass) throws Exception {
        TranslateExceptions.instrumentJdbcMethods(cjClazz, jdbcClass, false, null);
    }

    private static void instrumentJdbcMethods(CtClass cjClazz, Class<?> jdbcClass, boolean declaredMethodsOnly, String exceptionInterceptorStr) throws Exception {
        TranslateExceptions.sysOutPrintln("---");
        TranslateExceptions.sysOutPrintln(cjClazz.getName());
        Method[] methods = declaredMethodsOnly ? jdbcClass.getDeclaredMethods() : jdbcClass.getMethods();
        for (Method method : methods) {
            CtMethod ctm = null;
            String prefix = "SKIPPED:         ";
            for (Class<?> exc : method.getExceptionTypes()) {
                if (!exc.equals(SQLException.class)) continue;
                prefix = "INSTRUMENTING... ";
                String jdbcClassName = method.getName();
                LinkedList<CtClass> params = new LinkedList<CtClass>();
                for (Class<?> param : method.getParameterTypes()) {
                    params.add(pool.get(param.getName()));
                }
                try {
                    ctm = cjClazz.getDeclaredMethod(jdbcClassName, params.toArray(new CtClass[0]));
                }
                catch (NotFoundException ex) {
                    prefix = "NOT FOUND:       ";
                }
                break;
            }
            TranslateExceptions.sysOutPrint(prefix);
            TranslateExceptions.sysOutPrint(method.toGenericString());
            if (ctm != null) {
                if (TranslateExceptions.catchRuntimeException(cjClazz, ctm, exceptionInterceptorStr, false)) {
                    TranslateExceptions.sysOutPrint(" ... DONE.");
                } else {
                    TranslateExceptions.sysOutPrint(" ... ALREADY PROCESSED!!!");
                }
            }
            TranslateExceptions.sysOutPrintln("");
        }
    }

    private static void catchRuntimeException(CtClass clazz, CtMethod m, String exceptionInterceptorStr) throws Exception {
        TranslateExceptions.catchRuntimeException(clazz, m, exceptionInterceptorStr, true);
    }

    private static boolean catchRuntimeException(CtClass clazz, CtMethod m, String exceptionInterceptorStr, boolean log) throws Exception {
        if (TranslateExceptions.isProcessed(clazz.getClassFile().getName(), m)) {
            if (log) {
                TranslateExceptions.sysOutPrintln("ALREADY PROCESSED!!! " + m);
            }
            return false;
        }
        if (log) {
            TranslateExceptions.sysOutPrintln(m + ", " + exceptionInterceptorStr);
        }
        if (exceptionInterceptorStr == null) {
            m.addCatch("{throw " + SQLExceptionsMapping.class.getName() + ".translateException(ex);}", runTimeException, "ex");
        } else {
            m.addCatch("{throw " + SQLExceptionsMapping.class.getName() + ".translateException(ex, " + exceptionInterceptorStr + ");}", runTimeException, "ex");
        }
        processed.get(clazz.getClassFile().getName()).add(m);
        return true;
    }

    private static boolean isProcessed(String fileName, CtMethod m) throws Exception {
        List<CtMethod> methods = processed.get(fileName);
        if (methods != null) {
            if (methods.contains(m)) {
                return true;
            }
        } else {
            processed.put(fileName, new LinkedList());
        }
        return false;
    }

    private static void sysOutPrint(String s) {
        if (verbose) {
            System.out.print(s);
        }
    }

    private static void sysOutPrintln(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }
}

