/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.ArrayUtils;
import io.github.imsejin.common.util.CollectionUtils;
import io.github.imsejin.common.util.StringUtils;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class Descriptor<SELF extends Descriptor<SELF>> {
    protected final SELF self;
    private String description;
    private Object[] arguments;
    private Function<String, ? extends RuntimeException> exception = IllegalArgumentException::new;
    private List<Map.Entry<String, String>> descriptionVariables;

    protected Descriptor() {
        this.self = this;
    }

    protected Descriptor(Descriptor<?> descriptor) {
        this();
        this.description = descriptor.description;
        this.arguments = descriptor.arguments;
        this.exception = descriptor.exception;
    }

    public final SELF describedAs(String description, Object ... args) {
        this.description = Objects.requireNonNull(description, "Descriptor.description cannot be null");
        this.arguments = Objects.requireNonNull(args, "Descriptor.arguments cannot be null");
        return this.self;
    }

    public final SELF thrownBy(Function<String, ? extends RuntimeException> function) {
        this.exception = Objects.requireNonNull(function, "Descriptor.exception cannot be null");
        return this.self;
    }

    protected final void setDefaultDescription(String description, Object ... args) {
        if (!StringUtils.isNullOrEmpty(this.description)) {
            return;
        }
        this.describedAs(description, args);
    }

    @SafeVarargs
    protected final void setDescriptionVariables(Map.Entry<String, Object> ... variables) {
        ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> descriptionVariables = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
        for (Map.Entry<String, Object> variable : variables) {
            String value = ArrayUtils.toString(variable.getValue());
            AbstractMap.SimpleImmutableEntry<String, String> entry = new AbstractMap.SimpleImmutableEntry<String, String>(variable.getKey(), value);
            descriptionVariables.add(entry);
        }
        this.descriptionVariables = Collections.unmodifiableList(descriptionVariables);
    }

    protected final RuntimeException getException() {
        String message = this.getFailureMessage();
        if (CollectionUtils.exists(this.descriptionVariables)) {
            StringBuilder sb = new StringBuilder(message);
            for (Map.Entry<String, String> variable : this.descriptionVariables) {
                sb.append("\n    ").append(variable.getKey()).append(": '").append(variable.getValue()).append("'");
            }
            message = sb.toString();
        }
        return this.exception.apply(message);
    }

    private String getFailureMessage() {
        if (StringUtils.isNullOrEmpty(this.description)) {
            return "";
        }
        String pattern = this.description.replace("'", "''");
        MessageFormat messageFormat = new MessageFormat(pattern);
        String[] strings = new String[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            String string;
            Object argument = this.arguments[i];
            strings[i] = string = ArrayUtils.toString(argument);
        }
        return messageFormat.format(strings);
    }

    @Deprecated
    @ExcludeFromGeneratedJacocoReport
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

