/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.composition;

import java.util.function.BiPredicate;

public interface PositionComparisonAssertable<SELF extends PositionComparisonAssertable<SELF, ACTUAL>, ACTUAL> {
    public static final BiPredicate<Comparable, Comparable<?>> IS_EQUAL_TO = (actual, expected) -> actual.equals(expected) || actual.compareTo(expected) == 0;
    public static final BiPredicate<Comparable, Comparable<?>> IS_NOT_EQUAL_TO = (actual, expected) -> !actual.equals(expected) && actual.compareTo(expected) != 0;
    public static final BiPredicate<Comparable, Comparable<?>> IS_BEFORE = (actual, expected) -> actual.compareTo(expected) < 0;
    public static final BiPredicate<Comparable, Comparable<?>> IS_BEFORE_OR_EQUAL_TO = (actual, expected) -> actual.compareTo(expected) <= 0;
    public static final BiPredicate<Comparable, Comparable<?>> IS_AFTER_THAN = (actual, expected) -> actual.compareTo(expected) > 0;
    public static final BiPredicate<Comparable, Comparable<?>> IS_AFTER_THAN_OR_EQUAL_TO = (actual, expected) -> actual.compareTo(expected) >= 0;
    public static final String DEFAULT_DESCRIPTION_IS_EQUAL_TO = "They are expected to be equal, but they aren't.";
    public static final String DEFAULT_DESCRIPTION_IS_NOT_EQUAL_TO = "They are expected to be not equal, but they are.";
    public static final String DEFAULT_DESCRIPTION_IS_BEFORE = "It is expected to be before than the other, but it isn't.";
    public static final String DEFAULT_DESCRIPTION_IS_BEFORE_OR_EQUAL_TO = "It is expected to be before than or equal to the other, but it isn't.";
    public static final String DEFAULT_DESCRIPTION_IS_AFTER_THAN = "It is expected to be after than the other, but it isn't.";
    public static final String DEFAULT_DESCRIPTION_IS_AFTER_THAN_OR_EQUAL_TO = "It is expected to be after than or equal to the other, but it isn't.";

    public SELF isBefore(ACTUAL var1);

    public SELF isBeforeOrEqualTo(ACTUAL var1);

    public SELF isAfter(ACTUAL var1);

    public SELF isAfterOrEqualTo(ACTUAL var1);

    default public SELF isBetween(ACTUAL startInclusive, ACTUAL endInclusive) {
        return this.isAfterOrEqualTo(startInclusive).isBeforeOrEqualTo(endInclusive);
    }

    default public SELF isStrictlyBetween(ACTUAL startExclusive, ACTUAL endExclusive) {
        return this.isAfter(startExclusive).isBefore(endExclusive);
    }
}

