/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.io;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.SizeAssertable;
import io.github.imsejin.common.assertion.lang.LongAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.assertion.nio.file.PathAssert;
import io.github.imsejin.common.util.FilenameUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractMap;

public class FileAssert<SELF extends FileAssert<SELF, ACTUAL>, ACTUAL extends File>
extends ObjectAssert<SELF, ACTUAL>
implements SizeAssertable<SELF, ACTUAL> {
    public FileAssert(ACTUAL actual) {
        super(actual);
    }

    protected FileAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEmpty() {
        long length = ((File)this.actual).length();
        if (length > 0L) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", length));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF isNotEmpty() {
        long length = ((File)this.actual).length();
        if (length == 0L) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", length));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSize(long expected) {
        long size = ((File)this.actual).length();
        if (size != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSize(long expected) {
        long size = ((File)this.actual).length();
        if (size == expected) {
            this.setDefaultDescription("It is expected not to have the given size, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSameSizeAs(ACTUAL expected) {
        Long expectedSize;
        long actualSize = ((File)this.actual).length();
        Long l = expectedSize = expected == null ? null : Long.valueOf(((File)expected).length());
        if (expected == null || actualSize != expectedSize) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Long>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSameSizeAs(ACTUAL expected) {
        Long expectedSize;
        long actualSize = ((File)this.actual).length();
        Long l = expectedSize = expected == null ? null : Long.valueOf(((File)expected).length());
        if (expected == null || actualSize == expectedSize) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Long>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThan(long expected) {
        if (((File)this.actual).length() <= expected) {
            this.setDefaultDescription("It is expected to have size greater than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", ((File)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(long expected) {
        if (((File)this.actual).length() < expected) {
            this.setDefaultDescription("It is expected to have size greater than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", ((File)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThan(long expected) {
        if (((File)this.actual).length() >= expected) {
            this.setDefaultDescription("It is expected to have size less than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", ((File)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(long expected) {
        if (((File)this.actual).length() > expected) {
            this.setDefaultDescription("It is expected to have size less than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", ((File)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF exists() {
        if (!((File)this.actual).exists()) {
            this.setDefaultDescription("It is expected to exist, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isFile() {
        if (!((File)this.actual).isFile()) {
            this.setDefaultDescription("It is expected to be file, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isNotFile() {
        if (((File)this.actual).isFile()) {
            this.setDefaultDescription("It is expected not to be file, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isDirectory() {
        if (!((File)this.actual).isDirectory()) {
            this.setDefaultDescription("It is expected to be directory, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isNotDirectory() {
        if (((File)this.actual).isDirectory()) {
            this.setDefaultDescription("It is expected not to be directory, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isAbsolute() {
        if (!((File)this.actual).isAbsolute()) {
            this.setDefaultDescription("It is expected to be absolute, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isRelative() {
        if (((File)this.actual).isAbsolute()) {
            this.setDefaultDescription("It is expected to be relative, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isHidden() {
        if (!((File)this.actual).isHidden()) {
            this.setDefaultDescription("It is expected to be hidden, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF isNotHidden() {
        if (((File)this.actual).isHidden()) {
            this.setDefaultDescription("It is expected not to be hidden, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF hasName(String expected) {
        String name = ((File)this.actual).getName();
        if (!name.equals(expected)) {
            this.setDefaultDescription("It is expected to have the given name, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.name", name), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public SELF hasExtension(String expected) {
        String extension = FilenameUtils.getExtension(((File)this.actual).getName());
        if (!extension.equals(expected)) {
            this.setDefaultDescription("It is expected to have the given extension, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.extension", extension), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((FileAssert)this.self);
    }

    public FileAssert<?, File> asParentFile() {
        File parentFile = ((File)this.actual).getParentFile();
        return new FileAssert<SELF, File>(this, parentFile);
    }

    public PathAssert<?, Path> asPath() {
        Path path = ((File)this.actual).toPath();
        class PathAssertImpl
        extends PathAssert<PathAssertImpl, Path> {
            PathAssertImpl(Descriptor<?> descriptor, Path actual) {
                super(descriptor, actual);
            }
        }
        return new PathAssertImpl(this, path);
    }

    public LongAssert<?> asLength() {
        long length = ((File)this.actual).length();
        class LongAssertImpl
        extends LongAssert<LongAssertImpl> {
            LongAssertImpl(Descriptor<?> descriptor, Long actual) {
                super(descriptor, actual);
            }
        }
        return new LongAssertImpl(this, length);
    }

    public StringAssert<?> asName() {
        String name = ((File)this.actual).getName();
        class StringAssertImpl
        extends StringAssert<StringAssertImpl> {
            StringAssertImpl(Descriptor<?> descriptor, String actual) {
                super(descriptor, actual);
            }
        }
        return new StringAssertImpl(this, name);
    }
}

