/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.AmountAssertable;
import io.github.imsejin.common.assertion.composition.AmountComparisonAssertable;
import io.github.imsejin.common.assertion.lang.DoubleAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Objects;

public abstract class AbstractNumberAssert<SELF extends AbstractNumberAssert<SELF, ACTUAL>, ACTUAL extends Number>
extends ObjectAssert<SELF, ACTUAL>
implements AmountAssertable<SELF, ACTUAL>,
AmountComparisonAssertable<SELF, ACTUAL> {
    private final ACTUAL zero;
    private final Comparator<? super ACTUAL> comparator;

    protected <N extends Comparable<? super N>> AbstractNumberAssert(N actual, N zero) {
        this((Number)((Object)actual), (Number)((Object)zero), Comparator.naturalOrder());
    }

    protected AbstractNumberAssert(ACTUAL actual, ACTUAL zero, Comparator<ACTUAL> comparator) {
        super(actual);
        this.zero = zero;
        this.comparator = comparator;
    }

    protected <N extends Comparable<? super N>> AbstractNumberAssert(Descriptor<?> descriptor, N actual, N zero) {
        this(descriptor, (Number)((Object)actual), (Number)((Object)zero), Comparator.naturalOrder());
    }

    protected AbstractNumberAssert(Descriptor<?> descriptor, ACTUAL actual, ACTUAL zero, Comparator<? super ACTUAL> comparator) {
        super(descriptor, actual);
        this.zero = zero;
        this.comparator = comparator;
    }

    @Override
    public SELF isEqualTo(ACTUAL expected) {
        if (!((Number)this.actual).equals(expected) && this.comparator.compare(this.actual, expected) != 0) {
            this.setDefaultDescription("They are expected to be equal, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isNotEqualTo(ACTUAL expected) {
        if (((Number)this.actual).equals(expected) || this.comparator.compare(this.actual, expected) == 0) {
            this.setDefaultDescription("They are expected to be not equal, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isGreaterThan(ACTUAL expected) {
        if (this.comparator.compare(this.actual, expected) <= 0) {
            this.setDefaultDescription("It is expected to be greater than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(ACTUAL expected) {
        if (this.comparator.compare(this.actual, expected) < 0) {
            this.setDefaultDescription("It is expected to be greater than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isLessThan(ACTUAL expected) {
        if (this.comparator.compare(this.actual, expected) >= 0) {
            this.setDefaultDescription("It is expected to be less than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isLessThanOrEqualTo(ACTUAL expected) {
        if (this.comparator.compare(this.actual, expected) > 0) {
            this.setDefaultDescription("It is expected to be less than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isPositive() {
        if (this.comparator.compare(this.actual, this.zero) <= 0) {
            this.setDefaultDescription("It is expected to be positive, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isZeroOrPositive() {
        if (this.comparator.compare(this.actual, this.zero) < 0) {
            this.setDefaultDescription("It is expected to be zero or positive, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isNegative() {
        if (this.comparator.compare(this.actual, this.zero) >= 0) {
            this.setDefaultDescription("It is expected to be negative, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    @Override
    public SELF isZeroOrNegative() {
        if (this.comparator.compare(this.actual, this.zero) > 0) {
            this.setDefaultDescription("It is expected to be zero or negative, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }

    public SELF isCloseTo(ACTUAL expected, double percentage) {
        boolean invalid;
        ((DoubleAssert)((DoubleAssert)Asserts.that(percentage).describedAs("Error percentage must be zero or positive and less than 100, but it isn't: {0}", percentage)).isZeroOrPositive()).isLessThan(100.0);
        if (percentage == 0.0) {
            return this.isEqualTo(expected);
        }
        if (Objects.deepEquals(this.actual, expected)) {
            return (SELF)((AbstractNumberAssert)this.self);
        }
        if (expected == null) {
            this.setDefaultDescription("It is expected to close to other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("expected", null), new AbstractMap.SimpleEntry<String, Double>("percentage", percentage));
            throw this.getException();
        }
        double $actual = ((Number)this.actual).doubleValue();
        double $expected = ((Number)expected).doubleValue();
        if (Double.isNaN($actual) || Double.isInfinite($actual) || Double.isNaN($expected) || Double.isInfinite($expected)) {
            this.setDefaultDescription("It is expected to close to other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Double>("percentage", percentage));
            throw this.getException();
        }
        double diff = Math.abs($actual - $expected);
        double errorRate = diff / $actual * 100.0;
        boolean bl = invalid = Double.isNaN(errorRate) || Double.isInfinite(errorRate);
        if (invalid || Math.abs(errorRate) > percentage) {
            String $percentage = BigDecimal.valueOf(percentage).stripTrailingZeros().toPlainString();
            this.setDefaultDescription("It is expected to close to other by less than {0}%, but difference was {1}%.", $percentage, invalid ? Double.valueOf(errorRate) : BigDecimal.valueOf(errorRate).stripTrailingZeros().toPlainString());
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, String>("actual", BigDecimal.valueOf($actual).stripTrailingZeros().toPlainString()), new AbstractMap.SimpleEntry<String, String>("expected", BigDecimal.valueOf($expected).stripTrailingZeros().toPlainString()), new AbstractMap.SimpleEntry<String, String>("percentage", $percentage));
            throw this.getException();
        }
        return (SELF)((AbstractNumberAssert)this.self);
    }
}

