/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.EnumerationAssertable;
import io.github.imsejin.common.assertion.composition.IterationAssertable;
import io.github.imsejin.common.assertion.composition.RandomAccessIterationAssertable;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.util.ListAssert;
import io.github.imsejin.common.util.ArrayUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;

public class ArrayAssert<SELF extends ArrayAssert<SELF, ELEMENT>, ELEMENT>
extends ObjectAssert<SELF, ELEMENT[]>
implements EnumerationAssertable<SELF, ELEMENT>,
IterationAssertable<SELF, ELEMENT[], ELEMENT>,
RandomAccessIterationAssertable<SELF, ELEMENT> {
    public ArrayAssert(ELEMENT[] actual) {
        super(actual);
    }

    protected ArrayAssert(Descriptor<?> descriptor, ELEMENT[] actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEmpty() {
        if (((Object[])this.actual).length > 0) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF isNotEmpty() {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSize(long expected) {
        if ((long)((Object[])this.actual).length != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSize(long expected) {
        if ((long)((Object[])this.actual).length == expected) {
            this.setDefaultDescription("It is expected not to have the given size, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSameSizeAs(Object[] expected) {
        Integer expectedSize;
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.length);
        if (expected == null || ((Object[])this.actual).length != expectedSize) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Object[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSameSizeAs(Object[] expected) {
        Integer expectedSize;
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.length);
        if (expected == null || ((Object[])this.actual).length == expectedSize) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Object[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThan(long expected) {
        if ((long)((Object[])this.actual).length <= expected) {
            this.setDefaultDescription("It is expected to have size greater than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(long expected) {
        if ((long)((Object[])this.actual).length < expected) {
            this.setDefaultDescription("It is expected to have size greater than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThan(long expected) {
        if ((long)((Object[])this.actual).length >= expected) {
            this.setDefaultDescription("It is expected to have size less than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(long expected) {
        if ((long)((Object[])this.actual).length > expected) {
            this.setDefaultDescription("It is expected to have size less than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF contains(ELEMENT expected) {
        for (Object element : (Object[])this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain the given element, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected));
        throw this.getException();
    }

    @Override
    public SELF doesNotContain(ELEMENT expected) {
        for (Object element : (Object[])this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            this.setDefaultDescription("It is expected not to contain the given element, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF containsNull() {
        for (Object element : (Object[])this.actual) {
            if (element != null) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain null, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
        throw this.getException();
    }

    @Override
    public SELF doesNotContainNull() {
        for (Object element : (Object[])this.actual) {
            if (element != null) continue;
            this.setDefaultDescription("It is expected not to contain null, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsAny(ELEMENT ... expected) {
        if (((Object[])this.actual).length == 0 && expected.length == 0) {
            return (SELF)((ArrayAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                return (SELF)((ArrayAssert)this.self);
            }
        }
        this.setDefaultDescription("It is expected to contain at least one of the given element(s), but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected));
        throw this.getException();
    }

    @Override
    public SELF containsAll(ELEMENT[] expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        block0: for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (Objects.deepEquals(element, item)) continue block0;
            }
            this.setDefaultDescription("It is expected to contain all the given elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, ELEMENT>("missing", item));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotContainAll(ELEMENT[] expected) {
        if (((Object[])this.actual).length == 0 || ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                this.setDefaultDescription("It is expected not to contain all the given elements, but it is.", new Object[0]);
                this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Object>("included", element));
                throw this.getException();
            }
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnly(ELEMENT ... expected) {
        if (((Object[])this.actual).length == 0 && expected.length == 0) {
            return (SELF)((ArrayAssert)this.self);
        }
        block0: for (ELEMENT ELEMENT : expected) {
            for (Object element : (Object[])this.actual) {
                if (Objects.deepEquals(element, ELEMENT)) continue block0;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it doesn't contain some element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, ELEMENT>("missing", ELEMENT));
            throw this.getException();
        }
        block2: for (Object object : (Object[])this.actual) {
            for (ELEMENT item : expected) {
                if (Objects.deepEquals(object, item)) continue block2;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Object>("unexpected", object));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF containsOnlyNulls() {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        for (Object element : (Object[])this.actual) {
            if (element == null) continue;
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        if (((Object[])this.actual).length == 0 || ((Object[])this.actual).length == 1) {
            return (SELF)((ArrayAssert)this.self);
        }
        TreeSet<Object> noDuplicates = new TreeSet<Object>((o1, o2) -> {
            if (Objects.deepEquals(o1, o2)) {
                return 0;
            }
            return ArrayUtils.hashCode(o1) < ArrayUtils.hashCode(o2) ? -1 : 1;
        });
        for (Object element : (Object[])this.actual) {
            if (noDuplicates.contains(element)) {
                this.setDefaultDescription("It is expected not to have duplicated elements, but it is.", new Object[0]);
                this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("duplicated", element));
                throw this.getException();
            }
            noDuplicates.add(element);
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF anyMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Object[])this.actual) {
            if (!expected.test(element)) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to match the given condition with its any elements, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
        throw this.getException();
    }

    @Override
    public SELF allMatch(Predicate<ELEMENT> expected) {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        for (Object element : (Object[])this.actual) {
            if (expected.test(element)) continue;
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("unmatched", element));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF noneMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Object[])this.actual) {
            if (!expected.test(element)) continue;
            this.setDefaultDescription("It is expected not to match the given condition with its all elements, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("matched", element));
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF startsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        if (((Object[])this.actual).length < expected.length) {
            this.setDefaultDescription("It is expected to start with the given element(s), but it has fewer element(s) than that.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expected.length));
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            Object element = ((Object[])this.actual)[i];
            ELEMENT item = expected[i];
            if (Objects.deepEquals(element, item)) continue;
            this.setDefaultDescription("It is expected to start with the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Object>("unexpected", element));
            throw this.getException();
        }
        return null;
    }

    @Override
    @SafeVarargs
    public final SELF endsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        if (((Object[])this.actual).length < expected.length) {
            this.setDefaultDescription("It is expected to end with the given element(s), but it has fewer element(s) than that.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Object[])this.actual).length), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expected.length));
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            Object element = ((Object[])this.actual)[((Object[])this.actual).length - expected.length + i];
            ELEMENT item = expected[i];
            if (Objects.deepEquals(element, item)) continue;
            this.setDefaultDescription("It is expected to end with the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Object>("unexpected", element));
            throw this.getException();
        }
        return null;
    }

    public IntegerAssert<?> asLength() {
        return new IntegerAssert((Descriptor<?>)this, ((Object[])this.actual).length);
    }

    public ListAssert<?, List<ELEMENT>, ELEMENT> asList() {
        List<Object> list = Arrays.asList((Object[])this.actual);
        class ListAssertImpl
        extends ListAssert<ListAssertImpl, List<ELEMENT>, ELEMENT> {
            ListAssertImpl(Descriptor<?> descriptor, List<ELEMENT> actual) {
                super(descriptor, actual);
            }
        }
        return new ListAssertImpl(this, list);
    }
}

