/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.EnumerationAssertable;
import io.github.imsejin.common.assertion.composition.SizeAssertable;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.util.AbstractMap;

public class CharSequenceAssert<SELF extends CharSequenceAssert<SELF, ACTUAL, ELEMENT>, ACTUAL extends CharSequence, ELEMENT extends CharSequence>
extends ObjectAssert<SELF, ACTUAL>
implements SizeAssertable<SELF, ACTUAL>,
EnumerationAssertable<SELF, ACTUAL> {
    public CharSequenceAssert(ACTUAL actual) {
        super(actual);
    }

    protected CharSequenceAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEmpty() {
        int length = ((CharSequence)this.actual).length();
        if (length > 0) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", length));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF isNotEmpty() {
        int length = ((CharSequence)this.actual).length();
        if (length <= 0) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", length));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSize(long expected) {
        int size = ((CharSequence)this.actual).length();
        if ((long)size != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSize(long expected) {
        int size = ((CharSequence)this.actual).length();
        if ((long)size == expected) {
            this.setDefaultDescription("It is expected not to have the given size, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSameSizeAs(ACTUAL expected) {
        Integer expectedSize;
        int actualSize = ((CharSequence)this.actual).length();
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.length());
        if (expected == null || actualSize != expectedSize) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSameSizeAs(ACTUAL expected) {
        Integer expectedSize;
        int actualSize = ((CharSequence)this.actual).length();
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.length());
        if (expected == null || actualSize == expectedSize) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThan(long expected) {
        if ((long)((CharSequence)this.actual).length() <= expected) {
            this.setDefaultDescription("It is expected to have size greater than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((CharSequence)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(long expected) {
        if ((long)((CharSequence)this.actual).length() < expected) {
            this.setDefaultDescription("It is expected to have size greater than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((CharSequence)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThan(long expected) {
        if ((long)((CharSequence)this.actual).length() >= expected) {
            this.setDefaultDescription("It is expected to have size less than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((CharSequence)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(long expected) {
        if ((long)((CharSequence)this.actual).length() > expected) {
            this.setDefaultDescription("It is expected to have size less than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((CharSequence)this.actual).length()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF contains(ACTUAL expected) {
        if (expected == null || !((CharSequence)this.actual).toString().contains((CharSequence)expected)) {
            this.setDefaultDescription("It is expected to contain the given character(s), but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    @Override
    public SELF doesNotContain(ACTUAL expected) {
        if (expected == null || ((CharSequence)this.actual).toString().contains((CharSequence)expected)) {
            this.setDefaultDescription("It is expected not to contain the given character(s), but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public IntegerAssert<?> asLength() {
        int length = ((CharSequence)this.actual).length();
        return new IntegerAssert((Descriptor<?>)this, length);
    }
}

