/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ClassAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.ClassUtils;
import jakarta.validation.constraints.Null;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class ObjectAssert<SELF extends ObjectAssert<SELF, ACTUAL>, ACTUAL>
extends Descriptor<SELF> {
    @Null
    protected final ACTUAL actual;

    public ObjectAssert(ACTUAL actual) {
        this.actual = actual;
    }

    protected ObjectAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor);
        this.actual = actual;
    }

    public SELF isNull() {
        if (this.actual != null) {
            this.setDefaultDescription("It is expected to be null, but not null.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotNull() {
        if (this.actual == null) {
            this.setDefaultDescription("It is expected not to be null, but null.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", null));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isSameAs(ACTUAL expected) {
        if (this.actual != expected) {
            this.setDefaultDescription("They are expected to be the same, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotSameAs(ACTUAL expected) {
        if (this.actual == expected) {
            this.setDefaultDescription("They are expected to be not the same, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isEqualTo(ACTUAL expected) {
        if (!Objects.deepEquals(this.actual, expected)) {
            this.setDefaultDescription("They are expected to be equal, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotEqualTo(ACTUAL expected) {
        if (Objects.deepEquals(this.actual, expected)) {
            this.setDefaultDescription("They are expected to be not equal, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isInstanceOf(Class<?> expected) {
        Class<?> wrappedType = ClassUtils.wrap(expected);
        if (!wrappedType.isInstance(this.actual)) {
            this.setDefaultDescription("It is expected to be instance of the type, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry("actual.class", this.actual.getClass()), new AbstractMap.SimpleEntry("expected", wrappedType));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotInstanceOf(Class<?> expected) {
        Class<?> wrappedType = ClassUtils.wrap(expected);
        if (wrappedType.isInstance(this.actual)) {
            this.setDefaultDescription("It is expected not to be instance of the type, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry("actual.class", this.actual.getClass()), new AbstractMap.SimpleEntry("expected", wrappedType));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF is(Predicate<ACTUAL> condition) {
        if (!Objects.requireNonNull(condition, "Predicate cannot be null").test(this.actual)) {
            this.setDefaultDescription("It is expected to satisfy the given condition, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNot(Predicate<ACTUAL> condition) {
        if (Objects.requireNonNull(condition, "Predicate cannot be null").test(this.actual)) {
            this.setDefaultDescription("It is expected not to satisfy the given condition, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public <T> SELF returns(T expected, Function<ACTUAL, T> from) {
        T returned = Objects.requireNonNull(from, "Function is not allowed to be null").apply(this.actual);
        if (!Objects.deepEquals(returned, expected)) {
            this.setDefaultDescription("It is expected to return the given value via function, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, ACTUAL>("actual", this.actual), new AbstractMap.SimpleEntry<String, T>("returned", returned), new AbstractMap.SimpleEntry<String, T>("expected", expected));
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public ClassAssert<?, ACTUAL> asClass() {
        Class<?> clazz = this.actual.getClass();
        return new ClassAssert((Descriptor<?>)this, clazz);
    }

    public StringAssert<?> asString() {
        String string = this.actual.toString();
        return new StringAssert((Descriptor<?>)this, string);
    }
}

