/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.AmountAssertable;
import io.github.imsejin.common.assertion.composition.AmountComparisonAssertable;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.math.BigDecimalAssert;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.AbstractMap;

public class DurationAssert<SELF extends DurationAssert<SELF>>
extends ObjectAssert<SELF, Duration>
implements AmountAssertable<SELF, Duration>,
AmountComparisonAssertable<SELF, Duration> {
    public DurationAssert(Duration actual) {
        super(actual);
    }

    protected DurationAssert(Descriptor<?> descriptor, Duration actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isGreaterThan(Duration expected) {
        if (!AmountComparisonAssertable.IS_GREATER_THAN.test((Comparable)this.actual, expected)) {
            this.setDefaultDescription("It is expected to be greater than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Duration>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(Duration expected) {
        if (!AmountComparisonAssertable.IS_GREATER_THAN_OR_EQUAL_TO.test((Comparable)this.actual, expected)) {
            this.setDefaultDescription("It is expected to be greater than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Duration>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isLessThan(Duration expected) {
        if (!AmountComparisonAssertable.IS_LESS_THAN.test((Comparable)this.actual, expected)) {
            this.setDefaultDescription("It is expected to be less than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Duration>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isLessThanOrEqualTo(Duration expected) {
        if (!AmountComparisonAssertable.IS_LESS_THAN_OR_EQUAL_TO.test((Comparable)this.actual, expected)) {
            this.setDefaultDescription("It is expected to be less than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Duration>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isPositive() {
        if (((Duration)this.actual).isZero() || ((Duration)this.actual).isNegative()) {
            this.setDefaultDescription("It is expected to be positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isZeroOrPositive() {
        if (((Duration)this.actual).isNegative()) {
            this.setDefaultDescription("It is expected to be zero or positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isNegative() {
        if (!((Duration)this.actual).isNegative()) {
            this.setDefaultDescription("It is expected to be negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    @Override
    public SELF isZeroOrNegative() {
        if (!((Duration)this.actual).isZero() && !((Duration)this.actual).isNegative()) {
            this.setDefaultDescription("It is expected to be zero or negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((DurationAssert)this.self);
    }

    public BigDecimalAssert<?> asTotalSeconds() {
        BigDecimal totalSeconds = new BigDecimal(((Duration)this.actual).getSeconds() + "." + ((Duration)this.actual).getNano());
        class BigDecimalAssertImpl
        extends BigDecimalAssert<BigDecimalAssertImpl> {
            BigDecimalAssertImpl(Descriptor<?> descriptor, BigDecimal actual) {
                super(descriptor, actual);
            }
        }
        return new BigDecimalAssertImpl(this, totalSeconds);
    }
}

