/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.OffsetAssertable;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.OffsetTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoZonedDateTimeAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.AbstractMap;

public class OffsetDateTimeAssert<SELF extends OffsetDateTimeAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, OffsetDateTime>
implements OffsetAssertable<SELF, OffsetDateTime> {
    public OffsetDateTimeAssert(OffsetDateTime actual) {
        super(actual);
    }

    protected OffsetDateTimeAssert(Descriptor<?> descriptor, OffsetDateTime actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetDateTime)this.actual).getOffset();
        if (!offset.equals(expected)) {
            this.setDefaultDescription("They are expected to have the same offset, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ZoneOffset>("actual.offset", offset), new AbstractMap.SimpleEntry<String, ZoneOffset>("expected", expected));
            throw this.getException();
        }
        return (SELF)((OffsetDateTimeAssert)this.self);
    }

    @Override
    public SELF isNotSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetDateTime)this.actual).getOffset();
        if (offset.equals(expected)) {
            this.setDefaultDescription("They are expected not to have the same offset, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ZoneOffset>("actual.offset", offset), new AbstractMap.SimpleEntry<String, ZoneOffset>("expected", expected));
            throw this.getException();
        }
        return (SELF)((OffsetDateTimeAssert)this.self);
    }

    public ChronoLocalDateAssert<?> asLocalDate() {
        LocalDate localDate = ((OffsetDateTime)this.actual).toLocalDate();
        class ChronoLocalDateAssertImpl
        extends ChronoLocalDateAssert<ChronoLocalDateAssertImpl> {
            ChronoLocalDateAssertImpl(Descriptor<?> descriptor, ChronoLocalDate actual) {
                super(descriptor, actual);
            }
        }
        return new ChronoLocalDateAssertImpl(this, localDate);
    }

    public ChronoLocalDateTimeAssert<?, LocalDate> asLocalDateTime() {
        LocalDateTime localDateTime = ((OffsetDateTime)this.actual).toLocalDateTime();
        class ChronoLocalDateTimeAssertImpl
        extends ChronoLocalDateTimeAssert<ChronoLocalDateTimeAssertImpl, LocalDate> {
            protected ChronoLocalDateTimeAssertImpl(Descriptor<?> descriptor, ChronoLocalDateTime<?> actual) {
                super(descriptor, actual);
            }
        }
        return new ChronoLocalDateTimeAssertImpl(this, localDateTime);
    }

    public ChronoZonedDateTimeAssert<?, LocalDate> asZonedDateTime() {
        ZonedDateTime zonedDateTime = ((OffsetDateTime)this.actual).toZonedDateTime();
        class ChronoZonedDateTimeAssertImpl
        extends ChronoZonedDateTimeAssert<ChronoZonedDateTimeAssertImpl, LocalDate> {
            ChronoZonedDateTimeAssertImpl(Descriptor<?> descriptor, ChronoZonedDateTime<?> actual) {
                super(descriptor, actual);
            }
        }
        return new ChronoZonedDateTimeAssertImpl(this, zonedDateTime);
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTime localTime = ((OffsetDateTime)this.actual).toLocalTime();
        return new LocalTimeAssert((Descriptor<?>)this, localTime);
    }

    public OffsetTimeAssert<?> asOffsetTime() {
        OffsetTime offsetTime = ((OffsetDateTime)this.actual).toOffsetTime();
        return new OffsetTimeAssert((Descriptor<?>)this, offsetTime);
    }

    public InstantAssert<?> asInstant() {
        Instant instant = ((OffsetDateTime)this.actual).toInstant();
        return new InstantAssert((Descriptor<?>)this, instant);
    }
}

