/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.YearAssertable;
import io.github.imsejin.common.assertion.time.MonthAssert;
import io.github.imsejin.common.assertion.time.YearAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.AbstractMap;

public class YearMonthAssert<SELF extends YearMonthAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, YearMonth>
implements YearAssertable<SELF, YearMonth> {
    public YearMonthAssert(YearMonth actual) {
        super(actual);
    }

    protected YearMonthAssert(Descriptor<?> descriptor, YearMonth actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isLeapYear() {
        if (!((YearMonth)this.actual).isLeapYear()) {
            this.setDefaultDescription("It is expected to be leap year, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((YearMonthAssert)this.self);
    }

    @Override
    public SELF isNotLeapYear() {
        if (((YearMonth)this.actual).isLeapYear()) {
            this.setDefaultDescription("It is expected not to be leap year, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((YearMonthAssert)this.self);
    }

    public YearAssert<?> asYear() {
        Year year = Year.of(((YearMonth)this.actual).getYear());
        return new YearAssert((Descriptor<?>)this, year);
    }

    public MonthAssert<?> asMonth() {
        Month month = Month.of(((YearMonth)this.actual).getMonthValue());
        return new MonthAssert((Descriptor<?>)this, month);
    }
}

