/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.util.CollectionAssert;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MapAssert<SELF extends MapAssert<SELF, ACTUAL, KEY, VALUE>, ACTUAL extends Map<KEY, VALUE>, KEY, VALUE>
extends ObjectAssert<SELF, ACTUAL> {
    public MapAssert(ACTUAL actual) {
        super(actual);
    }

    protected MapAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    public SELF isEmpty() {
        if (!((Map)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", this.actual);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF isNotEmpty() {
        if (((Map)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", this.actual);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF hasSize(int expected) {
        if (((Map)this.actual).size() != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", expected, ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF hasSameSizeAs(Map<?, ?> expected) {
        if (expected == null || ((Map)this.actual).size() != expected.size()) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", expected == null ? "null" : Integer.valueOf(expected.size()), ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF doesNotHaveSameSizeAs(Map<?, ?> expected) {
        if (expected == null || ((Map)this.actual).size() == expected.size()) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", expected == null ? "null" : Integer.valueOf(expected.size()), ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsKey(KEY expected) {
        if (!((Map)this.actual).containsKey(expected)) {
            this.setDefaultDescription("It is expected to contain the given key, but it doesn't. (expected: '{0}', actual: '{1}')", expected, ((Map)this.actual).keySet());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsValue(VALUE expected) {
        if (!((Map)this.actual).containsValue(expected)) {
            this.setDefaultDescription("It is expected to contain the given value, but it doesn't. (expected: '{0}', actual: '{1}')", expected, ((Map)this.actual).values());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsAllKeys(Map<? extends KEY, ?> expected) {
        return this.containsAllKeys(expected.keySet());
    }

    public SELF containsAllKeys(Collection<? extends KEY> expected) {
        Set actualKeys = ((Map)this.actual).keySet();
        if (!actualKeys.containsAll(expected)) {
            this.setDefaultDescription("It is expected to contain all the given keys, but it doesn't. (expected: '{0}', actual: '{1}')", expected, actualKeys);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsAllValues(Map<?, ? extends VALUE> expected) {
        return this.containsAllValues(expected.values());
    }

    public SELF containsAllValues(Collection<? extends VALUE> expected) {
        Collection actualValues = ((Map)this.actual).values();
        if (!actualValues.containsAll(expected)) {
            this.setDefaultDescription("It is expected to contain all the given values, but it doesn't. (expected: '{0}', actual: '{1}')", expected, actualValues);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public CollectionAssert<?, Collection<KEY>, KEY> asKeySet() {
        return new CollectionAssert(this, ((Map)this.actual).keySet());
    }

    public CollectionAssert<?, Collection<VALUE>, VALUE> asValues() {
        return new CollectionAssert(this, ((Map)this.actual).values());
    }

    public IntegerAssert<?> asSize() {
        int size = ((Map)this.actual).size();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, size);
    }
}

