/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util.concurrent.atomic;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.HolderAssertable;
import io.github.imsejin.common.assertion.lang.AbstractNumberAssert;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerAssert<SELF extends AtomicIntegerAssert<SELF>>
extends AbstractNumberAssert<SELF, AtomicInteger>
implements HolderAssertable<SELF, Integer> {
    private static final AtomicInteger ZERO = new AtomicInteger(0);

    public AtomicIntegerAssert(AtomicInteger actual) {
        super(actual, ZERO, Comparator.comparingInt(AtomicInteger::get));
    }

    protected AtomicIntegerAssert(Descriptor<?> descriptor, AtomicInteger actual) {
        super(descriptor, actual, ZERO, Comparator.comparingInt(AtomicInteger::get));
    }

    @Override
    public SELF hasValue(Integer expected) {
        if (expected == null || ((AtomicInteger)this.actual).get() != expected.intValue()) {
            this.setDefaultDescription("It is expected to have the given value, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AtomicIntegerAssert)this.self);
    }

    @Override
    public SELF doesNotHaveValue(Integer expected) {
        if (expected != null && ((AtomicInteger)this.actual).get() == expected.intValue()) {
            this.setDefaultDescription("It is expected not to have the given value, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AtomicIntegerAssert)this.self);
    }
}

