/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.constant;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.util.MapAssert;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DateType {
    YEAR("yyyy"),
    MONTH("MM"),
    DAY("dd"),
    HOUR("HH"),
    MINUTE("mm"),
    SECOND("ss"),
    MILLISECOND("SSS"),
    YEAR_MONTH(DateType.YEAR.pattern + DateType.MONTH.pattern),
    DATE(DateType.YEAR.pattern + DateType.MONTH.pattern + DateType.DAY.pattern),
    TIME(DateType.HOUR.pattern + DateType.MINUTE.pattern + DateType.SECOND.pattern),
    HOUR_2_MILSEC(DateType.TIME.pattern + DateType.MILLISECOND.pattern),
    DATE_TIME(DateType.DATE.pattern + DateType.TIME.pattern),
    ALL(DateType.DATE.pattern + DateType.HOUR_2_MILSEC.pattern),
    F_DATE(DateType.YEAR.pattern + '-' + DateType.MONTH.pattern + '-' + DateType.DAY.pattern),
    F_TIME(DateType.HOUR.pattern + ':' + DateType.MINUTE.pattern + ':' + DateType.SECOND.pattern),
    F_HOUR_2_MILSEC(DateType.F_TIME.pattern + '.' + DateType.MILLISECOND.pattern),
    F_DATE_TIME(DateType.F_DATE.pattern + ' ' + DateType.F_TIME.pattern),
    F_ALL(DateType.F_DATE.pattern + ' ' + DateType.F_HOUR_2_MILSEC.pattern);

    private final String pattern;
    private final DateTimeFormatter formatter;
    private static final Map<String, DateType> $CODE_LOOKUP;

    private DateType(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    public static boolean contains(String pattern) {
        return $CODE_LOOKUP.containsKey(pattern);
    }

    public static DateType from(String pattern) {
        ((MapAssert)Asserts.that($CODE_LOOKUP).describedAs("Enumeration 'DateType' has no value: '{0}'", pattern)).containsKey(pattern);
        return $CODE_LOOKUP.get(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    static {
        $CODE_LOOKUP = Arrays.stream(DateType.values()).collect(Collectors.collectingAndThen(Collectors.toMap(it -> it.pattern, Function.identity()), Collections::unmodifiableMap));
    }
}

