/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.io.finder;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.nio.file.PathAssert;
import io.github.imsejin.common.io.ArchiveResource;
import io.github.imsejin.common.io.Resource;
import io.github.imsejin.common.io.finder.ResourceFinder;
import jakarta.validation.constraints.Null;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public abstract class ArchiveResourceFinder<R extends ArchiveResource, E extends ArchiveEntry, I extends ArchiveInputStream>
implements ResourceFinder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Resource> getResources(Path path) {
        ((PathAssert)((Descriptor)((PathAssert)((Descriptor)((PathAssert)((PathAssert)((PathAssert)Asserts.that(path).describedAs("Invalid path to find resources: {0}", path)).isNotNull()).describedAs("No such path exists: {0}", path)).exists()).describedAs("It is not a regular file: {0}", path)).isRegularFile()).describedAs("Cannot read file: {0}", path)).is(Files::isReadable);
        try (I in = this.getArchiveInputStream(Files.newInputStream(path, new OpenOption[0]));){
            E entry;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            while ((entry = this.getNextArchiveEntry(in)) != null) {
                R resource = this.getArchiveResource(entry, in);
                if (resource == null) continue;
                resources.add((Resource)resource);
            }
            ArrayList<Resource> arrayList = resources;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to read tar file: " + path, e);
        }
    }

    protected abstract E getNextArchiveEntry(I var1) throws IOException;

    @Null
    protected abstract R getArchiveResource(E var1, I var2) throws IOException;

    protected abstract I getArchiveInputStream(InputStream var1) throws IOException;
}

