/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.io.finder;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.nio.file.PathAssert;
import io.github.imsejin.common.io.DiskFileResource;
import io.github.imsejin.common.io.Resource;
import io.github.imsejin.common.io.finder.ResourceFinder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DiskFileResourceFinder
implements ResourceFinder {
    private final boolean recursive;
    private final Predicate<Path> filter;

    public DiskFileResourceFinder(boolean recursive) {
        this(recursive, entry -> true);
    }

    public DiskFileResourceFinder(boolean recursive, Predicate<Path> filter) {
        this.recursive = recursive;
        this.filter = filter;
    }

    @Override
    public List<Resource> getResources(Path path) {
        Stream<Path> stream;
        ((PathAssert)((PathAssert)((PathAssert)Asserts.that(path).describedAs("Invalid path to find resources: {0}", path)).isNotNull()).describedAs("No such path exists: {0}", path)).exists();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            DiskFileResource resource = DiskFileResource.from(path);
            return Collections.singletonList(resource);
        }
        try {
            if (this.recursive) {
                stream = Files.walk(path, new FileVisitOption[0]);
            } else {
                stream = Files.list(path);
                stream = Stream.concat(Stream.of(path), stream);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to visit location: " + path, e);
        }
        return stream.filter(this.filter).map(DiskFileResource::from).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }
}

