/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.io.finder;

import io.github.imsejin.common.io.finder.TarResourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarGzipResourceFinder
extends TarResourceFinder {
    public TarGzipResourceFinder(boolean recursive) {
        this(recursive, entry -> true, StandardCharsets.UTF_8);
    }

    public TarGzipResourceFinder(boolean recursive, Predicate<ArchiveEntry> filter) {
        this(recursive, filter, StandardCharsets.UTF_8);
    }

    public TarGzipResourceFinder(boolean recursive, Predicate<ArchiveEntry> filter, Charset charset) {
        super(recursive, filter, charset);
    }

    @Override
    protected TarArchiveInputStream getArchiveInputStream(InputStream in) throws IOException {
        return super.getArchiveInputStream((InputStream)new GzipCompressorInputStream(in));
    }
}

