/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.io.finder;

import io.github.imsejin.common.io.TarResource;
import io.github.imsejin.common.io.finder.ArchiveResourceFinder;
import io.github.imsejin.common.util.FilenameUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarResourceFinder
extends ArchiveResourceFinder<TarResource, TarArchiveEntry, TarArchiveInputStream> {
    protected final boolean recursive;
    protected final Predicate<ArchiveEntry> filter;
    protected final Charset charset;

    public TarResourceFinder(boolean recursive) {
        this(recursive, entry -> true, StandardCharsets.UTF_8);
    }

    public TarResourceFinder(boolean recursive, Predicate<ArchiveEntry> filter) {
        this(recursive, filter, StandardCharsets.UTF_8);
    }

    public TarResourceFinder(boolean recursive, Predicate<ArchiveEntry> filter, Charset charset) {
        this.recursive = recursive;
        this.filter = filter;
        this.charset = charset;
    }

    @Override
    protected TarArchiveEntry getNextArchiveEntry(TarArchiveInputStream in) throws IOException {
        return in.getNextTarEntry();
    }

    @Override
    protected TarResource getArchiveResource(TarArchiveEntry entry, TarArchiveInputStream in) throws IOException {
        int offset;
        if (!this.filter.test((ArchiveEntry)entry)) {
            return null;
        }
        String path = entry.getName();
        String name = FilenameUtils.getName(path);
        boolean directory = entry.isDirectory();
        long size = entry.getSize();
        long modifiedMilliTime = entry.getLastModifiedDate().getTime();
        if (directory) {
            return new TarResource(path, name, null, size, true, modifiedMilliTime);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        while ((offset = in.read(buffer)) != -1) {
            out.write(buffer, 0, offset);
        }
        byte[] bytes = out.toByteArray();
        return new TarResource(path, name, new ByteArrayInputStream(bytes), size, false, modifiedMilliTime);
    }

    @Override
    protected TarArchiveInputStream getArchiveInputStream(InputStream in) throws IOException {
        return new TarArchiveInputStream(in, this.charset.name());
    }
}

