/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.security.model;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.time.DurationAssert;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public class Verification {
    private final Object credentials;
    private final Duration duration;
    private final LocalDateTime createdDateTime = LocalDateTime.now();

    public Verification(Object credentials, Duration duration) {
        ((ObjectAssert)Asserts.that(credentials).describedAs("Verification.credentials is allowed to be null", new Object[0])).isNotNull();
        ((DurationAssert)((DurationAssert)((DurationAssert)Asserts.that(duration).describedAs("Verification.duration is allowed to be null", new Object[0])).isNotNull()).describedAs("Verification.duration must be zero or positive, but it is not: '{0}'", duration)).isZeroOrPositive();
        this.credentials = credentials;
        this.duration = duration;
    }

    public boolean verify(Object credentials) {
        if (!Objects.deepEquals(this.credentials, credentials)) {
            return false;
        }
        return !this.isExpired();
    }

    public boolean isExpired() {
        BigDecimal thisDuration;
        Duration duration = Duration.between(this.createdDateTime, LocalDateTime.now());
        if (duration.isNegative()) {
            return true;
        }
        BigDecimal thatDuration = new BigDecimal(duration.getSeconds() + "." + duration.getNano());
        return thatDuration.compareTo(thisDuration = new BigDecimal(this.duration.getSeconds() + "." + this.duration.getNano())) > 0;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public LocalDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }
}

