/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.util.ListAssert;
import io.github.imsejin.common.constant.Locales;
import io.github.imsejin.common.util.StringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

public class RandomString {
    private static final Map<String, List<String>> LANGUAGE_UNICODE_POINT_MAP;
    private final Random random;
    private final char[] symbols;

    public RandomString() {
        this(new Random());
    }

    public RandomString(Random random) {
        this(random, Locales.ENGLISH);
    }

    public RandomString(Random random, Locale locale) {
        ((ObjectAssert)Asserts.that(random).describedAs("RandomString.random cannot be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(locale).describedAs("RandomString.locale cannot be null", new Object[0])).isNotNull()).describedAs("RandomString.locale has invalid language: '{0}'", locale.getLanguage())).isNot(it -> StringUtils.isNullOrBlank(it.getLanguage()));
        List<String> unicodePointRanges = LANGUAGE_UNICODE_POINT_MAP.get(locale.getLanguage());
        ((ListAssert)((ListAssert)((ListAssert)Asserts.that(unicodePointRanges).describedAs("Unsupported locale for RandomString: {0}", locale)).thrownBy(UnsupportedOperationException::new)).isNotNull()).isNotEmpty();
        StringBuilder sb = new StringBuilder();
        for (String range : unicodePointRanges) {
            String[] codePoints = range.split("-");
            if (codePoints.length == 1) {
                int codePoint = Integer.parseInt(codePoints[0]);
                sb.append((char)codePoint);
                continue;
            }
            int start = Integer.parseInt(codePoints[0]);
            int end = Integer.parseInt(codePoints[1]);
            for (int codePoint = start; codePoint <= end; ++codePoint) {
                sb.append((char)codePoint);
            }
        }
        this.random = random;
        this.symbols = sb.toString().toCharArray();
    }

    public String nextString(int length) {
        ((IntegerAssert)Asserts.that(length).describedAs("The length of random string must be positive, but it isn't: {0}", length)).isPositive();
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            int index = this.random.nextInt(this.symbols.length);
            chars[i] = this.symbols[index];
        }
        return new String(chars);
    }

    public String nextString(int origin, int bound) {
        ((IntegerAssert)((IntegerAssert)((IntegerAssert)Asserts.that(origin).describedAs("Origin must be positive, but it isn't: {0}", origin)).isPositive()).describedAs("Bound must be greater than origin, but it isn't. (origin: {0}, bound: {1})", origin, bound)).isLessThan(bound);
        int length = Math.max(origin, this.random.nextInt(bound));
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            int index = this.random.nextInt(this.symbols.length);
            chars[i] = this.symbols[index];
        }
        return new String(chars);
    }

    @VisibleForTesting
    static List<String> convertAsRanges(List<Integer> integers) {
        ArrayList<String> ranges = new ArrayList<String>();
        ArrayList<Integer> prevList = new ArrayList<Integer>();
        for (Integer curr : integers) {
            if (prevList.isEmpty()) {
                prevList.add(curr);
                continue;
            }
            Integer prev = (Integer)prevList.get(prevList.size() - 1);
            if (prev + 1 == curr) {
                prevList.add(curr);
                continue;
            }
            String range = prevList.size() == 1 ? String.valueOf(prevList.get(0)) : prevList.get(0) + "-" + prevList.get(prevList.size() - 1);
            ranges.add(range);
            prevList = new ArrayList();
            prevList.add(curr);
        }
        if (!prevList.isEmpty()) {
            String range = prevList.size() == 1 ? String.valueOf(prevList.get(0)) : prevList.get(0) + "-" + prevList.get(prevList.size() - 1);
            ranges.add(range);
        }
        return Collections.unmodifiableList(ranges);
    }

    static {
        HashMap<String, List<String>> languageUnicodeRangeMap = new HashMap<String, List<String>>();
        languageUnicodeRangeMap.put(Locales.ARABIC.getLanguage(), Collections.singletonList("1536-1791"));
        languageUnicodeRangeMap.put(Locales.CHINESE.getLanguage(), Collections.singletonList("19968-40908"));
        languageUnicodeRangeMap.put(Locales.ENGLISH.getLanguage(), Arrays.asList("65-90", "97-122"));
        languageUnicodeRangeMap.put(Locales.HEBREW.getLanguage(), Collections.singletonList("1424-1535"));
        languageUnicodeRangeMap.put(Locales.HINDI.getLanguage(), Collections.singletonList("2304-3455"));
        languageUnicodeRangeMap.put(Locales.JAPANESE.getLanguage(), Arrays.asList("12353-12438", "12449-12538"));
        languageUnicodeRangeMap.put(Locales.KOREAN.getLanguage(), Collections.singletonList("44032-55203"));
        LANGUAGE_UNICODE_POINT_MAP = languageUnicodeRangeMap.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), Collections.unmodifiableList((List)e.getValue()))).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }
}

