/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.BooleanAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.ArrayUtils;
import io.github.imsejin.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.VisibleForTesting;

public final class Stopwatch {
    @VisibleForTesting
    static final int ROUNDING_SCALE = 10;
    private final List<Task> tasks = new ArrayList<Task>();
    private long startNanoTime;
    private long totalNanoTime;
    private String currentTaskName;
    private TimeUnit timeUnit;

    public Stopwatch() {
        this(TimeUnit.NANOSECONDS);
    }

    public Stopwatch(TimeUnit timeUnit) {
        ((ObjectAssert)Asserts.that(timeUnit).describedAs("Stopwatch.timeUnit cannot be null", new Object[0])).isNotNull();
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        ((ObjectAssert)Asserts.that(timeUnit).describedAs("Stopwatch.timeUnit cannot be null", new Object[0])).isNotNull();
        this.timeUnit = timeUnit;
    }

    public void start() {
        this.start("", new Object[0]);
    }

    public void start(String format, Object ... args) {
        ((StringAssert)Asserts.that(format).describedAs("Stopwatch.taskName cannot be null", new Object[0])).isNotNull();
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).describedAs("Stopwatch cannot start while running", new Object[0])).thrownBy(UnsupportedOperationException::new)).isFalse();
        this.currentTaskName = ArrayUtils.isNullOrEmpty(args) ? format : String.format(format, args);
        this.startNanoTime = System.nanoTime();
    }

    public void stop() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).describedAs("Stopwatch cannot stop while not running", new Object[0])).thrownBy(UnsupportedOperationException::new)).isTrue();
        long elapsedNanoTime = System.nanoTime() - this.startNanoTime;
        this.totalNanoTime += elapsedNanoTime;
        Task task = new Task(this.currentTaskName, this.tasks.size(), elapsedNanoTime);
        this.tasks.add(task);
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public boolean hasNeverBeenStopped() {
        return this.tasks.isEmpty();
    }

    public void clear() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).describedAs("Stopwatch is running; stop it first to clear", new Object[0])).thrownBy(UnsupportedOperationException::new)).isFalse();
        this.forceClear();
    }

    public void forceClear() {
        this.tasks.clear();
        this.startNanoTime = 0L;
        this.totalNanoTime = 0L;
        this.currentTaskName = null;
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public BigDecimal getTotalTime() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.hasNeverBeenStopped()).describedAs("Stopwatch has no total time, because it has never been stopped", new Object[0])).thrownBy(UnsupportedOperationException::new)).isFalse();
        BigDecimal amount = BigDecimal.valueOf(this.totalNanoTime);
        return Stopwatch.convertTimeUnit(amount, TimeUnit.NANOSECONDS, this.timeUnit);
    }

    public BigDecimal getAverageTime() {
        BigDecimal totalTime = BigDecimal.valueOf(this.totalNanoTime);
        BigDecimal taskCount = BigDecimal.valueOf(this.tasks.size());
        BigDecimal amount = totalTime.divide(taskCount, 10, RoundingMode.HALF_UP);
        return Stopwatch.convertTimeUnit(amount, TimeUnit.NANOSECONDS, this.timeUnit);
    }

    public String getSummary() {
        BigDecimal totalTime = this.getTotalTime();
        BigDecimal averageTime = this.getAverageTime();
        String abbreviation = Stopwatch.getTimeUnitAbbreviation(this.timeUnit);
        return String.format("TOTAL = %s %s, AVERAGE = %s %s", totalTime, abbreviation, averageTime, abbreviation);
    }

    public String getStatistics() {
        String unitAbbr = Stopwatch.getTimeUnitAbbreviation(this.timeUnit);
        int timeUnitIndex = Math.max(unitAbbr.length(), this.tasks.stream().mapToInt(task -> task.getDisplayTime(this.timeUnit).length()).max().orElse(0));
        String timeUnitColumn = String.format("%-" + timeUnitIndex + "s", unitAbbr);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary());
        sb.append("\n--------------------------------------------------\n");
        sb.append(timeUnitColumn).append("  ").append(String.format("%-6c", Character.valueOf('%'))).append("  ").append("TASK_NAME");
        sb.append("\n--------------------------------------------------\n");
        BigDecimal totalTime = this.getTotalTime();
        for (Task task2 : this.tasks) {
            String displayTime = task2.getDisplayTime(this.timeUnit);
            displayTime = StringUtils.padEnd(timeUnitIndex, displayTime);
            sb.append(displayTime).append("  ");
            BigDecimal percentage = this.tasks.size() == 1 ? BigDecimal.valueOf(100L) : task2.getPercentage(totalTime, this.timeUnit);
            sb.append(String.format("%-6.2f", percentage)).append("  ");
            sb.append(task2.name).append('\n');
        }
        return sb.toString();
    }

    @VisibleForTesting
    static BigDecimal convertTimeUnit(BigDecimal amount, TimeUnit from, TimeUnit to) {
        BigDecimal converted;
        if (from == to) {
            converted = amount;
        } else if (from.ordinal() < to.ordinal()) {
            BigDecimal divisor = BigDecimal.valueOf(from.convert(1L, to));
            converted = amount.divide(divisor, 10, RoundingMode.HALF_UP);
        } else {
            BigDecimal multiplicand = BigDecimal.valueOf(to.convert(1L, from));
            converted = amount.multiply(multiplicand);
        }
        return converted.stripTrailingZeros();
    }

    @VisibleForTesting
    static String getTimeUnitAbbreviation(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hrs";
            }
            case DAYS: {
                return "days";
            }
        }
        throw new IllegalArgumentException("No TimeUnit equivalent for " + (Object)((Object)timeUnit));
    }

    public static final class Task {
        private final String name;
        private final int order;
        private final long elapsedNanoTime;

        @VisibleForTesting
        Task(@NotNull String name, @Range(from=0L, to=0x7FFFFFFEL) int order, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long elapsedNanoTime) {
            this.name = Objects.requireNonNull(name, "Task.name cannot be null");
            this.order = order;
            this.elapsedNanoTime = elapsedNanoTime;
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public long getElapsedNanoTime() {
            return this.elapsedNanoTime;
        }

        @VisibleForTesting
        String getDisplayTime(TimeUnit timeUnit) {
            BigDecimal elapsedNanoTime = BigDecimal.valueOf(this.elapsedNanoTime);
            BigDecimal taskTime = Stopwatch.convertTimeUnit(elapsedNanoTime, TimeUnit.NANOSECONDS, timeUnit);
            return taskTime.toString();
        }

        @VisibleForTesting
        BigDecimal getPercentage(BigDecimal totalTime, TimeUnit timeUnit) {
            if (totalTime.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal elapsedNanoTime = BigDecimal.valueOf(this.elapsedNanoTime);
            BigDecimal taskTime = Stopwatch.convertTimeUnit(totalTime, timeUnit, TimeUnit.NANOSECONDS);
            BigDecimal ratio = elapsedNanoTime.divide(taskTime, 10, RoundingMode.HALF_UP);
            return ratio.multiply(BigDecimal.valueOf(100L)).stripTrailingZeros();
        }

        public String toString() {
            return "Task(name=" + this.name + ", order=" + this.order + ", elapsedNanoTime=" + this.elapsedNanoTime + ")";
        }
    }
}

