/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TypeClassifier {
    @ExcludeFromGeneratedJacocoReport
    private TypeClassifier() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static enum Types {
        PRIMITIVE(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE, Void.TYPE),
        WRAPPER(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, Void.class),
        PRIMITIVE_NUMBER(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE),
        WRAPPER_NUMBER(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class),
        NUMBER((Class[])Stream.of(Types.PRIMITIVE_NUMBER.classes, Types.WRAPPER_NUMBER.classes).flatMap(Collection::stream).toArray(Class[]::new)),
        DATETIME(LocalTime.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class);

        private final Set<Class<?>> classes;

        private Types(Class<?> ... classes) {
            this.classes = Collections.unmodifiableSet(Stream.of(classes).collect(Collectors.toSet()));
        }

        public Set<Class<?>> getClasses() {
            return this.classes;
        }
    }
}

