/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class CollectionUtils {
    @ExcludeFromGeneratedJacocoReport
    private CollectionUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <E> Collection<E> ifNullOrEmpty(Collection<E> collection, Collection<E> defaultList) {
        return CollectionUtils.isNullOrEmpty(collection) ? defaultList : collection;
    }

    public static <E> Collection<E> ifNullOrEmpty(Collection<E> collection, Supplier<Collection<E>> supplier) {
        return CollectionUtils.isNullOrEmpty(collection) ? supplier.get() : collection;
    }

    public static <E> List<E> ifNullOrEmpty(List<E> list, List<E> defaultList) {
        return CollectionUtils.isNullOrEmpty(list) ? defaultList : list;
    }

    public static <E> List<E> ifNullOrEmpty(List<E> list, Supplier<List<E>> supplier) {
        return CollectionUtils.isNullOrEmpty(list) ? supplier.get() : list;
    }

    public static <E> Set<E> ifNullOrEmpty(Set<E> set, Set<E> defaultSet) {
        return CollectionUtils.isNullOrEmpty(set) ? defaultSet : set;
    }

    public static <E> Set<E> ifNullOrEmpty(Set<E> set, Supplier<Set<E>> supplier) {
        return CollectionUtils.isNullOrEmpty(set) ? supplier.get() : set;
    }

    public static <K, V> Map<K, V> ifNullOrEmpty(Map<K, V> map, Map<K, V> defaultMap) {
        return CollectionUtils.isNullOrEmpty(map) ? defaultMap : map;
    }

    public static <K, V> Map<K, V> ifNullOrEmpty(Map<K, V> map, Supplier<Map<K, V>> supplier) {
        return CollectionUtils.isNullOrEmpty(map) ? supplier.get() : map;
    }

    public static boolean exists(Collection<?> collection) {
        return !CollectionUtils.isNullOrEmpty(collection);
    }

    public static boolean exists(Map<?, ?> map) {
        return !CollectionUtils.isNullOrEmpty(map);
    }

    public static <E> Map<Integer, E> toMap(Collection<E> collection) {
        return collection.stream().collect(HashMap::new, (map, streamValue) -> map.put(map.size(), streamValue), Map::putAll);
    }

    public static long findMax(Collection<Long> collection) {
        return collection.stream().reduce(Long.MIN_VALUE, Math::max);
    }

    public static <E> List<List<E>> partitionBySize(List<E> list, int chunkSize) {
        ((IntegerAssert)Asserts.that(chunkSize).describedAs("Size of each list must be greater than 0", new Object[0])).isGreaterThan(0);
        int originSize = list.size();
        int quotient = Math.floorDiv(originSize, chunkSize);
        ArrayList<List<List<E>>> superList = new ArrayList<List<List<E>>>();
        for (int i = 0; i < quotient; ++i) {
            superList.add(list.subList(i * chunkSize, (i + 1) * chunkSize));
        }
        int remainder = Math.floorMod(originSize, chunkSize);
        if (remainder > 0) {
            superList.add(list.subList(chunkSize * quotient, chunkSize * quotient + remainder));
        }
        return superList;
    }

    public static <E> List<List<E>> partitionByCount(List<E> list, int count) {
        ((IntegerAssert)((IntegerAssert)((IntegerAssert)Asserts.that(count).describedAs("The number of lists must be greater than 0", new Object[0])).isGreaterThan(0)).describedAs("Count must be less than or equal to list's size", new Object[0])).isLessThanOrEqualTo(list.size());
        int originSize = list.size();
        int quotient = Math.floorDiv(originSize, count);
        int remainder = Math.floorMod(originSize, count);
        int loopCount = remainder > 0 ? count - 1 : count;
        ArrayList<List<List<E>>> outer = new ArrayList<List<List<E>>>();
        for (int i = 0; i < loopCount; ++i) {
            outer.add(list.subList(i * quotient, (i + 1) * quotient));
        }
        if (remainder > 0) {
            outer.add(list.subList(quotient * loopCount, originSize));
        }
        return outer;
    }

    public static double median(long ... numbers) {
        long[] longs = Arrays.copyOf(numbers, numbers.length);
        Arrays.sort(longs);
        double median = MathUtils.isOdd(longs.length) ? (double)longs[longs.length / 2] : (double)(longs[longs.length / 2] + longs[longs.length / 2 - 1]) / 2.0;
        return median;
    }

    public static double median(int ... numbers) {
        int[] ints = Arrays.copyOf(numbers, numbers.length);
        Arrays.sort(ints);
        double median = MathUtils.isOdd(ints.length) ? (double)ints[ints.length / 2] : (double)(ints[ints.length / 2] + ints[ints.length / 2 - 1]) / 2.0;
        return median;
    }
}

