/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectorUtils {
    @ExcludeFromGeneratedJacocoReport
    private CollectorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static <T extends Comparable<T>> Collector<T, ?, SortedMap<Integer, List<T>>> ranking() {
        return CollectorUtils.ranking(Function.identity(), Comparable::compareTo);
    }

    public static <T, R> Collector<T, ?, SortedMap<Integer, List<T>>> ranking(Function<T, R> propertyExtractor, Comparator<R> propertyComparator) {
        return Collectors.collectingAndThen(Collectors.groupingBy(propertyExtractor, () -> new TreeMap(propertyComparator), Collectors.toList()), map -> {
            class RankMap
            extends TreeMap<Integer, List<T>> {
                final /* synthetic */ Function val$propertyExtractor;

                RankMap(Function function) {
                    this.val$propertyExtractor = function;
                }

                @Override
                public String toString() {
                    return this.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> e.getKey() + " - " + v + " (" + this.val$propertyExtractor.apply(v) + ")")).collect(Collectors.joining("\n"));
                }
            }
            return map.entrySet().stream().collect(() -> new RankMap(propertyExtractor), (ranks, entry) -> {
                if (ranks.isEmpty()) {
                    ranks.put(1, entry.getValue());
                    return;
                }
                Integer lastRank = (Integer)ranks.lastKey();
                List items = (List)ranks.get(lastRank);
                ranks.put(lastRank + items.size(), entry.getValue());
            }, (left, right) -> {
                Object rightProp;
                List leftItems = (List)left.get(left.lastKey());
                List rightItems = (List)right.get(right.firstKey());
                Object leftProp = propertyExtractor.apply(leftItems.get(0));
                if (leftProp == (rightProp = propertyExtractor.apply(rightItems.get(0)))) {
                    leftItems.addAll(rightItems);
                    right.remove(right.firstKey());
                }
                int offset = (Integer)left.lastKey() + leftItems.size() - 1;
                right.forEach((rank, items) -> left.put(offset + rank, items));
            });
        });
    }

    public static <T extends Comparable<T>> Collector<T, ?, SortedMap<Integer, List<T>>> denseRanking() {
        return CollectorUtils.denseRanking(Function.identity(), Comparable::compareTo);
    }

    public static <T, R> Collector<T, ?, SortedMap<Integer, List<T>>> denseRanking(Function<T, R> propertyExtractor, Comparator<R> propertyComparator) {
        return Collectors.collectingAndThen(Collectors.groupingBy(propertyExtractor, () -> new TreeMap(propertyComparator), Collectors.toList()), map -> {
            class RankMap
            extends TreeMap<Integer, List<T>> {
                final /* synthetic */ Function val$propertyExtractor;

                RankMap(Function function) {
                    this.val$propertyExtractor = function;
                }

                @Override
                public String toString() {
                    return this.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> e.getKey() + " - " + v + " (" + this.val$propertyExtractor.apply(v) + ")")).collect(Collectors.joining("\n"));
                }
            }
            return map.entrySet().stream().collect(() -> new RankMap(propertyExtractor), (ranks, entry) -> {
                if (ranks.isEmpty()) {
                    ranks.put(1, entry.getValue());
                    return;
                }
                ranks.put((Integer)ranks.lastKey() + 1, entry.getValue());
            }, (left, right) -> {
                List rightItems = (List)right.get(right.firstKey());
                List leftItems = (List)left.get(left.lastKey());
                Object rightProp = propertyExtractor.apply(rightItems.get(0));
                Object leftProp = propertyExtractor.apply(leftItems.get(0));
                if (leftProp == rightProp) {
                    leftItems.addAll(rightItems);
                    right.remove(right.firstKey());
                }
                int offset = (Integer)left.lastKey() - 1;
                right.forEach((rank, items) -> left.put(offset + rank, items));
            });
        });
    }
}

