/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class FileUtils {
    @ExcludeFromGeneratedJacocoReport
    private FileUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static BasicFileAttributes getFileAttributes(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void download(URL url, Path dest) {
        try {
            FileUtils.download(url.openStream(), dest);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void download(InputStream in, Path dest) {
        try (ReadableByteChannel readChannel = Channels.newChannel(in);
             FileChannel channel = FileChannel.open(dest, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            channel.transferFrom(readChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<Path> findAllFiles(Path path, FileVisitOption ... options) {
        try {
            return Files.find(path, Integer.MAX_VALUE, (p, bfa) -> bfa.isRegularFile(), options).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void deleteRecursively(Path path, FileVisitOption ... options) {
        try {
            Path[] paths;
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.delete(path);
                return;
            }
            for (Path p : paths = (Path[])Files.walk(path, options).sorted(Comparator.reverseOrder()).toArray(Path[]::new)) {
                Files.delete(p);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

