/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.StringUtils;
import jakarta.validation.constraints.Null;

public final class FilenameUtils {
    private static final char EXTENSION_SEPARATOR = '.';

    @ExcludeFromGeneratedJacocoReport
    private FilenameUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static int indexOfExtension(@Null String filename) {
        if (filename == null) {
            return -1;
        }
        int index = filename.lastIndexOf(46);
        return index == 0 ? -1 : index;
    }

    public static String getName(String path) {
        if (StringUtils.isNullOrEmpty(path)) {
            return "";
        }
        int index = (path = path.trim()).lastIndexOf(92);
        if (index == -1) {
            index = path.lastIndexOf(47);
        }
        if (index == -1) {
            return path;
        }
        if (index == path.length() - 1) {
            String chopped = StringUtils.chop(path);
            return FilenameUtils.getName(chopped);
        }
        return path.substring(index + 1);
    }

    public static String getBaseName(@Null String filename) {
        if (filename == null) {
            return "";
        }
        int index = FilenameUtils.indexOfExtension(filename);
        return index == -1 ? filename : filename.substring(0, index);
    }

    public static String getExtension(@Null String filename) {
        if (filename == null) {
            return "";
        }
        int index = FilenameUtils.indexOfExtension(filename);
        return index == -1 ? "" : filename.substring(index + 1);
    }

    public static String replaceUnallowables(String filename) {
        return filename.replace('\\', '\uff3c').replace('/', '\uff0f').replace(':', '\uff1a').replace('*', '\uff0a').replace('?', '\uff1f').replace('\"', '\uff02').replace('<', '\uff1c').replace('>', '\uff1e').replace('|', '\uff5c').replaceAll("\\.{2,}+$", "\u2026").replaceAll("\\.$", "\uff0e");
    }
}

