/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public final class JsonUtils {
    private static final Gson gson = new Gson();

    @ExcludeFromGeneratedJacocoReport
    private JsonUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static JsonObject readJsonFromUrl(URL url) {
        String jsonText;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            jsonText = JsonUtils.readAllLines(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return JsonParser.parseString((String)jsonText).getAsJsonObject();
    }

    private static String readAllLines(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static <T> T toObject(String jsonText, Class<T> clazz) {
        return (T)gson.fromJson(jsonText, clazz);
    }

    public static <T> List<T> toList(JsonArray jsonArray, Class<T> clazz) {
        return StreamUtils.toStream(jsonArray.iterator()).map(jsonElement -> gson.fromJson(jsonElement, clazz)).collect(Collectors.toList());
    }
}

