/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.ArithmeticDecimalNumberAssertable;
import io.github.imsejin.common.assertion.lang.AbstractNumberAssert;
import io.github.imsejin.common.util.NumberUtils;
import java.util.AbstractMap;

public class FloatAssert<SELF extends FloatAssert<SELF>>
extends AbstractNumberAssert<SELF, Float>
implements ArithmeticDecimalNumberAssertable<SELF, Float> {
    public FloatAssert(Float actual) {
        super(actual, Float.valueOf(0.0f));
    }

    protected FloatAssert(Descriptor<?> descriptor, Float actual) {
        super(descriptor, actual, Float.valueOf(0.0f));
    }

    @Override
    public SELF hasDecimalPart() {
        if (!NumberUtils.hasDecimalPart(((Float)this.actual).floatValue())) {
            this.setDefaultDescription("It is expected to have decimal part, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FloatAssert)this.self);
    }

    @Override
    public SELF isFinite() {
        if (!Float.isFinite(((Float)this.actual).floatValue())) {
            this.setDefaultDescription("It is expected to be finite, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FloatAssert)this.self);
    }

    @Override
    public SELF isInfinite() {
        if (!Float.isInfinite(((Float)this.actual).floatValue())) {
            this.setDefaultDescription("It is expected to be infinite, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FloatAssert)this.self);
    }

    @Override
    public SELF isNaN() {
        if (!Float.isNaN(((Float)this.actual).floatValue())) {
            this.setDefaultDescription("It is expected to be NaN (Not-a-Number), but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FloatAssert)this.self);
    }

    @Override
    public SELF isNotNaN() {
        if (Float.isNaN(((Float)this.actual).floatValue())) {
            this.setDefaultDescription("It is expected not to be NaN (Not-a-Number), but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((FloatAssert)this.self);
    }
}

