/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.net;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.StringUtils;
import java.net.URL;
import java.util.AbstractMap;

public class UrlAssert<SELF extends UrlAssert<SELF>>
extends ObjectAssert<SELF, URL> {
    public UrlAssert(URL actual) {
        super(actual);
    }

    protected UrlAssert(Descriptor<?> descriptor, URL actual) {
        super(descriptor, actual);
    }

    public SELF hasHost(String expected) {
        String host = ((URL)this.actual).getHost();
        if (StringUtils.isNullOrEmpty(host) || !host.equals(expected)) {
            this.setDefaultDescription("It is expected to have that host, but it doesn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.host", host), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public SELF doesNotHaveHost() {
        String host = ((URL)this.actual).getHost();
        if (!StringUtils.isNullOrEmpty(host)) {
            this.setDefaultDescription("It is expected not to have host, but it does.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.host", host));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public SELF hasPort(int expected) {
        int port;
        int n = port = ((URL)this.actual).getPort() == -1 ? ((URL)this.actual).getDefaultPort() : ((URL)this.actual).getPort();
        if (port != expected) {
            this.setDefaultDescription("It is expected to have that port, but it doesn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.port", port), new AbstractMap.SimpleEntry<String, Integer>("expected", expected));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public SELF doesNotHavePort() {
        int port;
        int n = port = ((URL)this.actual).getPort() == -1 ? ((URL)this.actual).getDefaultPort() : ((URL)this.actual).getPort();
        if (port != -1) {
            this.setDefaultDescription("It is expected not to have port, but it does.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.port", port));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public SELF hasPath(String expected) {
        String path = ((URL)this.actual).getPath();
        if (StringUtils.isNullOrEmpty(path) || !path.equals(expected)) {
            this.setDefaultDescription("It is expected to have that path, but it doesn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.path", path), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public SELF doesNotHavePath() {
        String path = ((URL)this.actual).getPath();
        if (!StringUtils.isNullOrEmpty(path)) {
            this.setDefaultDescription("It is expected not to have path, but it does.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.path", path));
            throw this.getException();
        }
        return (SELF)((UrlAssert)this.self);
    }

    public StringAssert<?> asHost() {
        String host = ((URL)this.actual).getHost();
        class StringAssertImpl
        extends StringAssert<StringAssertImpl> {
            StringAssertImpl(Descriptor<?> descriptor, String actual) {
                super(descriptor, actual);
            }
        }
        return new StringAssertImpl(this, host);
    }

    public IntegerAssert<?> asPort() {
        int port = ((URL)this.actual).getPort() == -1 ? ((URL)this.actual).getDefaultPort() : ((URL)this.actual).getPort();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, port);
    }

    public StringAssert<?> asPath() {
        String path = ((URL)this.actual).getPath();
        class StringAssertImpl
        extends StringAssert<StringAssertImpl> {
            StringAssertImpl(Descriptor<?> descriptor, String actual) {
                super(descriptor, actual);
            }
        }
        return new StringAssertImpl(this, path);
    }
}

