/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.nio.file;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.SizeAssertable;
import io.github.imsejin.common.assertion.io.FileAssert;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;

public class PathAssert<SELF extends PathAssert<SELF, ACTUAL>, ACTUAL extends Path>
extends ObjectAssert<SELF, ACTUAL>
implements SizeAssertable<SELF, ACTUAL> {
    public PathAssert(ACTUAL actual) {
        super(actual);
    }

    protected PathAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEmpty() {
        long size = this.getSize((Path)this.actual);
        if (size > 0L) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF isNotEmpty() {
        long size = this.getSize((Path)this.actual);
        if (size == 0L) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSize(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSize(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size == expected) {
            this.setDefaultDescription("It is expected not to have the given size, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSameSizeAs(ACTUAL expected) {
        Long expectedSize;
        long actualSize = this.getSize((Path)this.actual);
        Long l = expectedSize = expected == null ? null : Long.valueOf(this.getSize((Path)expected));
        if (expected == null || actualSize != expectedSize) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Long>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSameSizeAs(ACTUAL expected) {
        Long expectedSize;
        long actualSize = this.getSize((Path)this.actual);
        Long l = expectedSize = expected == null ? null : Long.valueOf(this.getSize((Path)expected));
        if (expected == null || actualSize == expectedSize) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", actualSize), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry<String, Long>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThan(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size <= expected) {
            this.setDefaultDescription("It is expected to have size greater than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size < expected) {
            this.setDefaultDescription("It is expected to have size greater than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThan(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size >= expected) {
            this.setDefaultDescription("It is expected to have size less than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(long expected) {
        long size = this.getSize((Path)this.actual);
        if (size > expected) {
            this.setDefaultDescription("It is expected to have size less than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF exists() {
        if (!Files.exists((Path)this.actual, new LinkOption[0])) {
            this.setDefaultDescription("It is expected to exist, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isRegularFile() {
        if (!Files.isRegularFile((Path)this.actual, new LinkOption[0])) {
            this.setDefaultDescription("It is expected to be regular file, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isNotRegularFile() {
        if (Files.isRegularFile((Path)this.actual, new LinkOption[0])) {
            this.setDefaultDescription("It is expected not to be regular file, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isDirectory() {
        if (!Files.isDirectory((Path)this.actual, new LinkOption[0])) {
            this.setDefaultDescription("It is expected to be directory, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isNotDirectory() {
        if (Files.isDirectory((Path)this.actual, new LinkOption[0])) {
            this.setDefaultDescription("It is expected not to be directory, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isAbsolute() {
        if (!((Path)this.actual).isAbsolute()) {
            this.setDefaultDescription("It is expected to be absolute, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isRelative() {
        if (((Path)this.actual).isAbsolute()) {
            this.setDefaultDescription("It is expected to be relative, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isHidden() {
        boolean hidden;
        try {
            hidden = Files.isHidden((Path)this.actual);
        }
        catch (IOException e) {
            this.setDefaultDescription("Failed to resolve whether path is hidden.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        if (!hidden) {
            this.setDefaultDescription("It is expected to be hidden, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF isNotHidden() {
        boolean hidden;
        try {
            hidden = Files.isHidden((Path)this.actual);
        }
        catch (IOException e) {
            this.setDefaultDescription("Failed to resolve whether path is hidden.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        if (hidden) {
            this.setDefaultDescription("It is expected not to be hidden, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF hasFileName(String expected) {
        String fileName = ((Path)this.actual).getFileName().toString();
        if (!fileName.equals(expected)) {
            this.setDefaultDescription("It is expected to have the given file name, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.fileName", fileName), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public SELF hasExtension(String expected) {
        String fileName = ((Path)this.actual).getFileName().toString();
        String extension = FilenameUtils.getExtension(fileName);
        if (!extension.equals(expected)) {
            this.setDefaultDescription("It is expected to have the given file extension, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, String>("actual.extension", extension), new AbstractMap.SimpleEntry<String, String>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PathAssert)this.self);
    }

    public PathAssert<?, Path> asParent() {
        Path parent = ((Path)this.actual).getParent();
        return new PathAssert<SELF, Path>(this, parent);
    }

    public FileAssert<?, File> asFile() {
        File file = ((Path)this.actual).toFile();
        class FileAssertImpl
        extends FileAssert<FileAssertImpl, File> {
            FileAssertImpl(Descriptor<?> descriptor, File actual) {
                super(descriptor, actual);
            }
        }
        return new FileAssertImpl(this, file);
    }

    public StringAssert<?> asFileName() {
        String fileName = ((Path)this.actual).getFileName().toString();
        class StringAssertImpl
        extends StringAssert<StringAssertImpl> {
            StringAssertImpl(Descriptor<?> descriptor, String actual) {
                super(descriptor, actual);
            }
        }
        return new StringAssertImpl(this, fileName);
    }

    public IntegerAssert<?> asNameCount() {
        int nameCount = ((Path)this.actual).getNameCount();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, nameCount);
    }

    private long getSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw this.getException();
        }
    }
}

