/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.LongAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.LocalTime;

public class LocalTimeAssert<SELF extends LocalTimeAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, LocalTime> {
    public LocalTimeAssert(LocalTime actual) {
        super(actual);
    }

    protected LocalTimeAssert(Descriptor<?> descriptor, LocalTime actual) {
        super(descriptor, actual);
    }

    public SELF isMidnight() {
        return (SELF)((LocalTimeAssert)super.isEqualTo(LocalTime.MIDNIGHT));
    }

    public SELF isNoon() {
        return (SELF)((LocalTimeAssert)super.isEqualTo(LocalTime.NOON));
    }

    public SELF isBeforeNoon() {
        return (SELF)((LocalTimeAssert)this.isBefore(LocalTime.NOON));
    }

    public SELF isBeforeOrEqualToNoon() {
        return (SELF)((LocalTimeAssert)this.isBeforeOrEqualTo(LocalTime.NOON));
    }

    public SELF isAfternoon() {
        return (SELF)((LocalTimeAssert)this.isAfter(LocalTime.NOON));
    }

    public SELF isAfterOrEqualToNoon() {
        return (SELF)((LocalTimeAssert)this.isAfterOrEqualTo(LocalTime.NOON));
    }

    public IntegerAssert<?> asSecondOfDay() {
        int secondOfDay = ((LocalTime)this.actual).toSecondOfDay();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, secondOfDay);
    }

    public LongAssert<?> asNanoOfDay() {
        long nanoOfDay = ((LocalTime)this.actual).toNanoOfDay();
        class LongAssertImpl
        extends LongAssert<LongAssertImpl> {
            LongAssertImpl(Descriptor<?> descriptor, Long actual) {
                super(descriptor, actual);
            }
        }
        return new LongAssertImpl(this, nanoOfDay);
    }
}

