/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.AmountAssertable;
import io.github.imsejin.common.assertion.composition.AmountComparisonAssertable;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.time.Period;
import java.util.AbstractMap;
import java.util.Comparator;

public class PeriodAssert<SELF extends PeriodAssert<SELF>>
extends ObjectAssert<SELF, Period>
implements AmountAssertable<SELF, Period>,
AmountComparisonAssertable<SELF, Period> {
    private static final Comparator<Period> COMPARATOR = (o1, o2) -> {
        int total1 = (o1.getYears() * 12 + o1.getMonths()) * 30 + o1.getDays();
        int total2 = (o2.getYears() * 12 + o2.getMonths()) * 30 + o2.getDays();
        return total1 - total2;
    };

    public PeriodAssert(Period actual) {
        super(actual);
    }

    protected PeriodAssert(Descriptor<?> descriptor, Period actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isGreaterThan(Period expected) {
        if (COMPARATOR.compare((Period)this.actual, expected) <= 0) {
            this.setDefaultDescription("It is expected to be greater than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Period>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(Period expected) {
        if (COMPARATOR.compare((Period)this.actual, expected) < 0) {
            this.setDefaultDescription("It is expected to be greater than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Period>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isLessThan(Period expected) {
        if (COMPARATOR.compare((Period)this.actual, expected) >= 0) {
            this.setDefaultDescription("It is expected to be less than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Period>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isLessThanOrEqualTo(Period expected) {
        if (COMPARATOR.compare((Period)this.actual, expected) > 0) {
            this.setDefaultDescription("It is expected to be less than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Period>("expected", expected));
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isPositive() {
        if (COMPARATOR.compare((Period)this.actual, Period.ZERO) <= 0) {
            this.setDefaultDescription("It is expected to be positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isZeroOrPositive() {
        if (COMPARATOR.compare((Period)this.actual, Period.ZERO) < 0) {
            this.setDefaultDescription("It is expected to be zero or positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isNegative() {
        if (COMPARATOR.compare((Period)this.actual, Period.ZERO) >= 0) {
            this.setDefaultDescription("It is expected to be negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    @Override
    public SELF isZeroOrNegative() {
        if (COMPARATOR.compare((Period)this.actual, Period.ZERO) > 0) {
            this.setDefaultDescription("It is expected to be zero or negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((PeriodAssert)this.self);
    }

    public IntegerAssert<?> asTotalDays() {
        int totalDays = (((Period)this.actual).getYears() * 12 + ((Period)this.actual).getMonths()) * 30 + ((Period)this.actual).getDays();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, totalDays);
    }
}

